/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.AbstractCharBase;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Char;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Matrix;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;

public class MatlabMatLoader
extends AbstractFileLoader
implements BatchConverter,
OptionHandler {
    private static final long serialVersionUID = 3764533621135196582L;
    public static final String FILE_EXTENSION = ".mat";
    public static final String DEFAULT_ENTRY_NAME = "";
    protected String m_EntryName = "";
    public static final int DEFAULT_MAX_NOMINAL_VALUES = 25;
    protected int m_MaxNominalValues = 25;
    protected Instances m_Data;

    public String globalInfo() {
        return "Reads binary Matlab .mat files.";
    }

    public void setEntryName(String value) {
        this.m_EntryName = value;
    }

    public String getEntryName() {
        return this.m_EntryName;
    }

    public String entryNameTipText() {
        return "The entry name to retrieve; first if empty.";
    }

    public void setMaxNominalValues(int value) {
        if (value < -1) {
            value = -1;
        }
        this.m_MaxNominalValues = value;
    }

    public int getMaxNominalValues() {
        return this.m_MaxNominalValues;
    }

    public String maxNominalValuesTipText() {
        return "The maximum number of values for nominal attributes, beyond that it is considered a string attribute; use -1 to always convert to nominal and 0 to always convert to string.";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    public String getFileDescription() {
        return "Matlab .mat files";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe entry name to retrieve; first if empty\n\t(default: )", "entry-name", 1, "-entry-name <name>"));
        result.addElement(new Option("\tThe maximum number of distinct values a NOMINAL attribute\n\tcan have; beyond that it is considered a STRING attribute.\n\tUse -1 to always convert to NOMINAL, 0 to always convert to STRING.\n\t(default: 25)", "max-nominal-values", 1, "-max-nominal-values <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmp = Utils.getOption((String)"entry-name", (String[])options);
        if (!tmp.isEmpty()) {
            this.setEntryName(tmp);
        } else {
            this.setEntryName(DEFAULT_ENTRY_NAME);
        }
        tmp = Utils.getOption((String)"max-nominal-values", (String[])options);
        if (!tmp.isEmpty()) {
            this.setMaxNominalValues(Integer.parseInt(tmp));
        } else {
            this.setMaxNominalValues(25);
        }
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-entry-name");
        result.add(this.getEntryName());
        result.add("-max-nominal-values");
        result.add(DEFAULT_ENTRY_NAME + this.getMaxNominalValues());
        return result.toArray(new String[0]);
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Data = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        }
    }

    public void setSource(File file) throws IOException {
        this.m_structure = null;
        this.m_Data = null;
        this.setRetrieval(0);
        if (file == null) {
            throw new IOException("Source file object is null!");
        }
        try {
            if (file.getName().endsWith(FILE_EXTENSION_COMPRESSED)) {
                this.setSource(new GZIPInputStream(new FileInputStream(file)));
            } else {
                this.setSource(new FileInputStream(file));
            }
        }
        catch (FileNotFoundException ex) {
            throw new IOException("File not found");
        }
        this.m_sourceFile = file;
        this.m_File = file.getAbsolutePath();
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
    }

    public Instances getStructure() throws IOException {
        if (this.m_structure != null) {
            return new Instances(this.m_structure, 0);
        }
        try {
            return new Instances(this.getDataSet(), 0);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Instances convert(Array array) throws IOException {
        int n;
        int i;
        if (array.getNumDimensions() > 2) {
            throw new IllegalStateException("Cannot handle arrays with more than two dimensions, received: " + array.getNumDimensions());
        }
        Matrix matrix = null;
        if (array instanceof Matrix) {
            matrix = (Matrix)array;
        }
        Cell matCell = null;
        if (array instanceof Cell) {
            matCell = (Cell)array;
        }
        Char matChar = null;
        if (array instanceof Char) {
            matChar = (Char)array;
        }
        if (matrix == null && matCell == null && matChar == null) {
            throw new IllegalStateException("Unhandled array type: " + array.getClass().getName());
        }
        Object[][] data = new Object[array.getNumRows()][array.getNumCols()];
        boolean[] numeric = new boolean[array.getNumCols()];
        for (i = 0; i < numeric.length; ++i) {
            numeric[i] = true;
        }
        for (n = 0; n < array.getNumRows(); ++n) {
            for (i = 0; i < array.getNumCols(); ++i) {
                if (matrix != null) {
                    data[n][i] = matrix.getDouble(n, i);
                    continue;
                }
                if (matCell != null) {
                    if (matCell.get(n, i) instanceof AbstractCharBase) {
                        data[n][i] = ((AbstractCharBase)matCell.get(n, i)).asCharSequence().toString();
                        numeric[i] = false;
                        continue;
                    }
                    String cell = matCell.get(n, i).toString();
                    try {
                        data[n][i] = Double.parseDouble(cell);
                    }
                    catch (Exception e) {
                        data[n][i] = cell;
                        numeric[i] = false;
                    }
                    continue;
                }
                if (matChar == null) continue;
                data[n][i] = Character.valueOf(matChar.getChar(n, i));
                numeric[i] = false;
            }
        }
        HashMap unique = new HashMap();
        for (i = 0; i < array.getNumCols(); ++i) {
            if (numeric[i]) continue;
            for (n = 0; n < array.getNumRows(); ++n) {
                if (!unique.containsKey(i)) {
                    unique.put(i, new HashSet());
                }
                ((Set)unique.get(i)).add((String)data[n][i]);
            }
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        for (i = 0; i < numeric.length; ++i) {
            if (numeric[i]) {
                atts.add(new Attribute("col-" + (i + 1)));
                continue;
            }
            if (this.m_MaxNominalValues == -1 || ((Set)unique.get(i)).size() <= this.m_MaxNominalValues) {
                ArrayList labels = new ArrayList((Collection)unique.get(i));
                Collections.sort(labels);
                atts.add(new Attribute("col-" + (i + 1), labels));
                continue;
            }
            atts.add(new Attribute("col-" + (i + 1), (List)null));
        }
        this.m_Data = new Instances(this.retrieveFile().getName(), atts, array.getNumRows());
        for (n = 0; n < array.getNumRows(); ++n) {
            double[] values = new double[this.m_Data.numAttributes()];
            for (i = 0; i < array.getNumCols(); ++i) {
                values[i] = this.m_Data.attribute(i).isNumeric() ? (Double)data[n][i] : (this.m_Data.attribute(i).isNominal() ? (double)this.m_Data.attribute(i).indexOfValue((String)data[n][i]) : (double)this.m_Data.attribute(i).addStringValue((String)data[n][i]));
            }
            this.m_Data.add((Instance)new DenseInstance(1.0, values));
        }
        return this.m_Data;
    }

    public Instances getDataSet() throws IOException {
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        Mat5File mat5 = Mat5.readFromFile((File)this.retrieveFile());
        Array array = null;
        int i = 0;
        System.err.println("Entries in: " + this.retrieveFile());
        for (MatFile.Entry entry : mat5.getEntries()) {
            System.err.println(i + 1 + ": " + entry.getName());
            if (entry.getName().equals(this.m_EntryName) || this.m_EntryName.isEmpty() && array == null) {
                array = entry.getValue();
            }
            ++i;
        }
        if (array == null) {
            throw new IOException("Failed to load array with name: " + this.m_EntryName);
        }
        this.m_Data = this.convert(array);
        this.m_structure = new Instances(this.m_Data, 0);
        return this.m_Data;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("Incremental loading not supported!");
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        MatlabMatLoader.runFileLoader((AbstractFileLoader)new MatlabMatLoader(), (String[])args);
    }
}

