/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.Cell;
import us.hebi.matlab.mat.types.Sinks;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.MatlabMatLoader;

public class MatlabMatSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7226404765213522043L;
    public static final String DEFAULT_ENTRY_NAME_META = "meta";
    protected String m_EntryNameMeta = "meta";
    public static final String DEFAULT_ENTRY_NAME_DATA = "data";
    protected String m_EntryNameData = "data";

    public MatlabMatSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes binary Matlab .mat files.\nThe header information is stored as well in three rows:\n- attribute names\n- attribute types\n- attribute format (eg to determine date format or nominal values)";
    }

    public void setEntryNameMeta(String value) {
        this.m_EntryNameMeta = value;
    }

    public String getEntryNameMeta() {
        return this.m_EntryNameMeta;
    }

    public String entryNameMetaTipText() {
        return "The entry name to use for the header.";
    }

    public void setEntryNameData(String value) {
        this.m_EntryNameData = value;
    }

    public String getEntryNameData() {
        return this.m_EntryNameData;
    }

    public String entryNameDataTipText() {
        return "The entry name to use for the data.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.add(enm.nextElement());
        }
        result.addElement(new Option("\tThe entry name to use for the header\n\t(default: meta)", "entry-name-meta", 1, "-entry-name-meta <name>"));
        result.addElement(new Option("\tThe entry name to use for the data\n\t(default: data)", "entry-name-data", 1, "-entry-name-data <name>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmp = Utils.getOption((String)"entry-name-meta", (String[])options);
        if (!tmp.isEmpty()) {
            this.setEntryNameMeta(tmp);
        } else {
            this.setEntryNameMeta(DEFAULT_ENTRY_NAME_META);
        }
        tmp = Utils.getOption((String)"entry-name-data", (String[])options);
        if (!tmp.isEmpty()) {
            this.setEntryNameData(tmp);
        } else {
            this.setEntryNameData(DEFAULT_ENTRY_NAME_DATA);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>(Arrays.asList(super.getOptions()));
        result.add("-entry-name-meta");
        result.add(this.getEntryNameMeta());
        result.add("-entry-name-data");
        result.add(this.getEntryNameData());
        return result.toArray(new String[0]);
    }

    public String getFileDescription() {
        return new MatlabMatLoader().getFileDescription();
    }

    public String[] getFileExtensions() {
        return new MatlabMatLoader().getFileExtensions();
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".mat");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void resetWriter() {
        super.resetWriter();
    }

    protected void writeHeader(Mat5File mat5, Instances data) {
        Cell cell = Mat5.newCell((int)3, (int)(data.numAttributes() + 1));
        cell.set(0, 0, (Array)Mat5.newString((String)"name"));
        cell.set(1, 0, (Array)Mat5.newString((String)"type"));
        cell.set(2, 0, (Array)Mat5.newString((String)"format"));
        for (int i = 0; i < data.numAttributes(); ++i) {
            cell.set(0, i + 1, (Array)Mat5.newString((String)data.attribute(i).name()));
            cell.set(1, i + 1, (Array)Mat5.newString((String)Attribute.typeToStringShort((int)data.attribute(i).type())));
            cell.set(2, i + 1, (Array)Mat5.newString((String)data.attribute(i).toString()));
        }
        mat5.addArray(this.m_EntryNameMeta, (Array)cell);
    }

    protected void writeData(Mat5File mat5, Instances data) {
        Cell cell = Mat5.newCell((int)data.numInstances(), (int)data.numAttributes());
        for (int n = 0; n < data.numInstances(); ++n) {
            Instance inst = data.instance(n);
            block4: for (int i = 0; i < data.numAttributes(); ++i) {
                switch (data.attribute(i).type()) {
                    case 0: {
                        cell.set(n, i, (Array)Mat5.newScalar((double)inst.value(i)));
                        continue block4;
                    }
                    default: {
                        cell.set(n, i, (Array)Mat5.newString((String)inst.stringValue(i)));
                    }
                }
            }
        }
        mat5.addArray(this.m_EntryNameData, (Array)cell);
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.m_EntryNameMeta.equals(this.m_EntryNameData)) {
            throw new IOException("Header and data name are the same: " + this.m_EntryNameMeta);
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        Mat5File mat5 = Mat5.newMatFile();
        Instances data = this.getInstances();
        this.writeHeader(mat5, data);
        this.writeData(mat5, data);
        mat5.writeTo(Sinks.newStreamingFile((File)this.retrieveFile()));
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        MatlabMatSaver.runFileSaver((AbstractFileSaver)new MatlabMatSaver(), (String[])args);
    }
}

