/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.maven.plugin.dependency.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyStatusSets {
    Set<Artifact> resolvedDependencies = null;
    Set<Artifact> unResolvedDependencies = null;
    Set<Artifact> skippedDependencies = null;

    public DependencyStatusSets() {
    }

    public DependencyStatusSets(Set<Artifact> resolved, Set<Artifact> unResolved, Set<Artifact> skipped) {
        if (resolved != null) {
            this.resolvedDependencies = new LinkedHashSet<Artifact>(resolved);
        }
        if (unResolved != null) {
            this.unResolvedDependencies = new LinkedHashSet<Artifact>(unResolved);
        }
        if (skipped != null) {
            this.skippedDependencies = new LinkedHashSet<Artifact>(skipped);
        }
    }

    public Set<Artifact> getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void setResolvedDependencies(Set<Artifact> resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies != null ? new LinkedHashSet<Artifact>(resolvedDependencies) : null;
    }

    public Set<Artifact> getSkippedDependencies() {
        return this.skippedDependencies;
    }

    public void setSkippedDependencies(Set<Artifact> skippedDependencies) {
        this.skippedDependencies = skippedDependencies != null ? new LinkedHashSet<Artifact>(skippedDependencies) : null;
    }

    public Set<Artifact> getUnResolvedDependencies() {
        return this.unResolvedDependencies;
    }

    public void setUnResolvedDependencies(Set<Artifact> unResolvedDependencies) {
        this.unResolvedDependencies = unResolvedDependencies != null ? new LinkedHashSet<Artifact>(unResolvedDependencies) : null;
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename) {
        return this.getOutput(outputAbsoluteArtifactFilename, true);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope) {
        return this.getOutput(outputAbsoluteArtifactFilename, outputScope, false);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean sort) {
        StringBuilder sb = new StringBuilder();
        if (this.resolvedDependencies != null && !this.resolvedDependencies.isEmpty()) {
            sb.append((CharSequence)this.buildArtifactListOutput(this.resolvedDependencies, outputAbsoluteArtifactFilename, outputScope, sort, true, true, true));
        }
        return sb.toString();
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean outputClassifier, boolean outputVersion, boolean outputGroupId, boolean sort) {
        StringBuilder sb = new StringBuilder();
        if (this.resolvedDependencies != null && !this.resolvedDependencies.isEmpty()) {
            sb.append((CharSequence)this.buildArtifactListOutput(this.resolvedDependencies, outputAbsoluteArtifactFilename, outputScope, outputClassifier, outputVersion, outputGroupId, sort));
        }
        return sb.toString();
    }

    private String artifactToString(Artifact artifact, boolean outputScope, boolean outputClassifier, boolean outputVersion, boolean outputGroupId) {
        StringBuilder result = new StringBuilder();
        if (outputGroupId) {
            result.append(artifact.getGroupId());
        }
        if (result.length() > 0) {
            result.append(":");
        }
        result.append(artifact.getArtifactId());
        if (outputClassifier && artifact.hasClassifier()) {
            result.append(":");
            result.append(artifact.getClassifier());
        }
        if (outputVersion) {
            result.append(":");
            result.append(artifact.getVersion());
        }
        if (outputScope) {
            result.append(":");
            result.append(artifact.getType());
        }
        return result.toString();
    }

    private StringBuilder buildArtifactListOutput(Set<Artifact> artifacts, boolean outputAbsoluteArtifactFilename, boolean outputScope, boolean outputClassifier, boolean outputVersion, boolean outputGroupId, boolean sort) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> artifactStringList = new ArrayList<String>();
        for (Artifact artifact : artifacts) {
            String artifactFilename = null;
            if (outputAbsoluteArtifactFilename) {
                try {
                    artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                }
                catch (NullPointerException e) {
                    artifactFilename = null;
                }
            }
            String id = this.artifactToString(artifact, outputScope, outputClassifier, outputVersion, outputGroupId);
            artifactStringList.add(id + (outputAbsoluteArtifactFilename ? ":" + artifactFilename : "") + "\n");
        }
        if (sort) {
            Collections.sort(artifactStringList);
        }
        for (String artifactString : artifactStringList) {
            sb.append(artifactString);
        }
        return sb;
    }
}

