/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.maven.plugin.dependency.utils.filters;

import com.github.fracpete.maven.plugin.dependency.fromConfiguration.ArtifactItem;
import com.github.fracpete.maven.plugin.dependency.utils.filters.ArtifactItemFilter;
import com.github.fracpete.maven.plugin.dependency.utils.markers.MarkerHandler;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;

public class MarkerFileFilter
extends AbstractArtifactsFilter
implements ArtifactItemFilter {
    private boolean overWriteReleases;
    private boolean overWriteSnapshots;
    private boolean overWriteIfNewer;
    protected final MarkerHandler handler;

    public MarkerFileFilter(boolean overWriteReleases, boolean overWriteSnapshots, boolean overWriteIfNewer, MarkerHandler handler) {
        this.overWriteReleases = overWriteReleases;
        this.overWriteSnapshots = overWriteSnapshots;
        this.overWriteIfNewer = overWriteIfNewer;
        this.handler = handler;
    }

    public Set filter(Set artifacts) throws ArtifactFilterException {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!this.isArtifactIncluded(new ArtifactItem(artifact))) continue;
            result.add(artifact);
        }
        return result;
    }

    public boolean isArtifactIncluded(ArtifactItem item) throws ArtifactFilterException {
        Artifact artifact = item.getArtifact();
        boolean overWrite = artifact.isSnapshot() && this.overWriteSnapshots || !artifact.isSnapshot() && this.overWriteReleases;
        this.handler.setArtifact(artifact);
        try {
            return overWrite || !this.handler.isMarkerSet() || this.overWriteIfNewer && this.handler.isMarkerOlder(artifact);
        }
        catch (MojoExecutionException e) {
            throw new ArtifactFilterException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isOverWriteReleases() {
        return this.overWriteReleases;
    }

    public void setOverWriteReleases(boolean overWriteReleases) {
        this.overWriteReleases = overWriteReleases;
    }

    public boolean isOverWriteSnapshots() {
        return this.overWriteSnapshots;
    }

    public void setOverWriteSnapshots(boolean overWriteSnapshots) {
        this.overWriteSnapshots = overWriteSnapshots;
    }

    public boolean isOverWriteIfNewer() {
        return this.overWriteIfNewer;
    }

    public void setOverWriteIfNewer(boolean overWriteIfNewer) {
        this.overWriteIfNewer = overWriteIfNewer;
    }
}

