/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.maven.plugin.dependency.utils.translators;

import com.github.fracpete.maven.plugin.dependency.utils.translators.ArtifactTranslator;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassifierTypeTranslator
implements ArtifactTranslator {
    private String classifier;
    private String type;
    private ArtifactFactory factory;

    public ClassifierTypeTranslator(String theClassifier, String theType, ArtifactFactory theFactory) {
        this.classifier = theClassifier;
        this.type = theType;
        this.factory = theFactory;
    }

    @Override
    public Set<Artifact> translate(Set<Artifact> artifacts, Log log) {
        log.debug((CharSequence)("Translating Artifacts using Classifier: " + this.classifier + " and Type: " + this.type));
        HashSet<Artifact> results = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            String useType = StringUtils.isNotEmpty((String)this.type) ? this.type : artifact.getType();
            String useClassifier = StringUtils.isNotEmpty((String)this.classifier) ? this.classifier : artifact.getClassifier();
            Artifact newArtifact = this.factory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), useType, useClassifier);
            newArtifact.setScope(artifact.getScope());
            results.add(newArtifact);
        }
        return results;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String theType) {
        this.type = theType;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String theClassifier) {
        this.classifier = theClassifier;
    }
}

