/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.missingvaluesimputation.Imputation;
import weka.filters.unsupervised.attribute.missingvaluesimputation.NullImputation;

public class MissingValuesImputation
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 8349568310991609867L;
    public static final String ALGORITHM = "algorithm";
    protected Imputation m_Algorithm = this.getDefaultAlgorithm();

    public String globalInfo() {
        return "Replaces missing values using the specified imputation algorithm.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe imputation algorithm to use.\n\t(default: " + this.getDefaultAlgorithm().getClass().getName() + ")", ALGORITHM, 1, "-algorithm <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-algorithm");
        result.add("" + Utils.toCommandLine((Object)this.getAlgorithm()));
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)ALGORITHM, (String[])options);
        if (!tmpStr.isEmpty()) {
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            Imputation imp = (Imputation)Utils.forName(Imputation.class, (String)tmpStr, (String[])tmpOptions);
            this.setAlgorithm(imp);
        } else {
            this.setAlgorithm(this.getDefaultAlgorithm());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected Imputation getDefaultAlgorithm() {
        return new NullImputation();
    }

    public void setAlgorithm(Imputation value) {
        this.m_Algorithm = value;
    }

    public Imputation getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The imputation algorithm to apply to the data.";
    }

    public Capabilities getCapabilities() {
        return this.m_Algorithm.getCapabilities();
    }

    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.m_Algorithm.buildImputation(inputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        return this.m_Algorithm.impute(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        MissingValuesImputation.runFilter((Filter)new MissingValuesImputation(), (String[])args);
    }
}

