/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleBatchFilter;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.missingvaluesinjection.Injection;
import weka.filters.unsupervised.attribute.missingvaluesinjection.NullInjection;

public class MissingValuesInjection
extends SimpleBatchFilter
implements UnsupervisedFilter {
    private static final long serialVersionUID = 8349568310991609867L;
    public static final String ALGORITHM = "algorithm";
    protected Injection m_Algorithm = this.getDefaultAlgorithm();

    public String globalInfo() {
        return "Injects missing values using the specified injection algorithm.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe injection algorithm to use.\n\t(default: " + this.getDefaultAlgorithm().getClass().getName() + ")", ALGORITHM, 1, "-algorithm <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-algorithm");
        result.add("" + Utils.toCommandLine((Object)this.getAlgorithm()));
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)ALGORITHM, (String[])options);
        if (!tmpStr.isEmpty()) {
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            Injection imp = (Injection)Utils.forName(Injection.class, (String)tmpStr, (String[])tmpOptions);
            this.setAlgorithm(imp);
        } else {
            this.setAlgorithm(this.getDefaultAlgorithm());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected Injection getDefaultAlgorithm() {
        return new NullInjection();
    }

    public void setAlgorithm(Injection value) {
        this.m_Algorithm = value;
    }

    public Injection getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The injection algorithm to apply to the data.";
    }

    public Capabilities getCapabilities() {
        return this.m_Algorithm.getCapabilities();
    }

    public boolean allowAccessToFullInputFormat() {
        return true;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        return this.m_Algorithm.buildInjection(inputFormat);
    }

    protected Instances process(Instances instances) throws Exception {
        return this.m_Algorithm.inject(instances);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        MissingValuesInjection.runFilter((Filter)new MissingValuesInjection(), (String[])args);
    }
}

