/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesimputation;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.WekaException;
import weka.filters.unsupervised.attribute.missingvaluesimputation.Imputation;

public abstract class AbstractImputation
implements Imputation,
OptionHandler {
    private static final long serialVersionUID = 8509594940625168327L;
    protected boolean m_Initialized = false;
    protected Instances m_OutputFormat;

    @Override
    public abstract String globalInfo();

    public Enumeration<Option> listOptions() {
        return new Vector().elements();
    }

    public String[] getOptions() {
        return new String[0];
    }

    public void setOptions(String[] options) throws Exception {
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public Capabilities getCapabilities(Instances data) {
        Capabilities result = this.getCapabilities();
        if (data.classIndex() == -1) {
            Capabilities classes = result.getClassCapabilities();
            Iterator iter = classes.capabilities();
            while (iter.hasNext()) {
                Capabilities.Capability cap = (Capabilities.Capability)iter.next();
                if (cap == Capabilities.Capability.NO_CLASS) continue;
                result.disable(cap);
                result.disableDependency(cap);
            }
        } else {
            result.disable(Capabilities.Capability.NO_CLASS);
            result.disableDependency(Capabilities.Capability.NO_CLASS);
        }
        return result;
    }

    protected void initImputation(Instances data) {
    }

    protected abstract Instances doBuildImputation(Instances var1) throws Exception;

    @Override
    public Instances buildImputation(Instances data) throws Exception {
        this.m_OutputFormat = null;
        this.getCapabilities(data).testWithFail(data);
        this.initImputation(data);
        this.m_OutputFormat = this.doBuildImputation(data);
        this.m_Initialized = true;
        return this.m_OutputFormat;
    }

    protected Instances doImpute(Instances data) throws Exception {
        Instances result = new Instances(data, data.numInstances());
        for (int i = 0; i < data.numInstances(); ++i) {
            result.add(this.doImpute(data.instance(i)));
        }
        return result;
    }

    @Override
    public Instances impute(Instances data) throws Exception {
        if (!this.m_Initialized) {
            throw new WekaException("Imputation algorithm '" + this.getClass().getName() + "' not initialized!");
        }
        return this.doImpute(data);
    }

    protected abstract Instance doImpute(Instance var1) throws Exception;

    @Override
    public Instance impute(Instance inst) throws Exception {
        if (!this.m_Initialized) {
            throw new WekaException("Imputation algorithm '" + this.getClass().getName() + "' not initialized!");
        }
        return this.doImpute(inst);
    }
}

