/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesimputation;

import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesimputation.AbstractImputation;

public class MeansAndModes
extends AbstractImputation {
    private static final long serialVersionUID = -3584692959239101972L;
    protected double[] m_ModesAndMeans = null;

    @Override
    public String globalInfo() {
        return "Replaces all missing values for nominal and numeric attributes in a dataset with the modes and means from the training data.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances doBuildImputation(Instances data) throws Exception {
        double sumOfWeights = data.sumOfWeights();
        double[][] counts = new double[data.numAttributes()][];
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (!data.attribute(i).isNominal()) continue;
            counts[i] = new double[data.attribute(i).numValues()];
            if (counts[i].length <= 0) continue;
            counts[i][0] = sumOfWeights;
        }
        double[] sums = new double[data.numAttributes()];
        for (int i = 0; i < sums.length; ++i) {
            sums[i] = sumOfWeights;
        }
        double[] results = new double[data.numAttributes()];
        for (int j = 0; j < data.numInstances(); ++j) {
            Instance inst = data.instance(j);
            for (int i = 0; i < inst.numValues(); ++i) {
                if (!inst.isMissingSparse(i)) {
                    double value = inst.valueSparse(i);
                    if (inst.attributeSparse(i).isNominal()) {
                        if (counts[inst.index(i)].length <= 0) continue;
                        double[] dArray = counts[inst.index(i)];
                        int n = (int)value;
                        dArray[n] = dArray[n] + inst.weight();
                        double[] dArray2 = counts[inst.index(i)];
                        dArray2[0] = dArray2[0] - inst.weight();
                        continue;
                    }
                    if (!inst.attributeSparse(i).isNumeric()) continue;
                    int n = inst.index(i);
                    results[n] = results[n] + inst.weight() * inst.valueSparse(i);
                    continue;
                }
                if (inst.attributeSparse(i).isNominal()) {
                    if (counts[inst.index(i)].length <= 0) continue;
                    double[] dArray = counts[inst.index(i)];
                    dArray[0] = dArray[0] - inst.weight();
                    continue;
                }
                if (!inst.attributeSparse(i).isNumeric()) continue;
                int n = inst.index(i);
                sums[n] = sums[n] - inst.weight();
            }
        }
        this.m_ModesAndMeans = new double[data.numAttributes()];
        for (int i = 0; i < data.numAttributes(); ++i) {
            if (data.attribute(i).isNominal()) {
                if (counts[i].length == 0) {
                    this.m_ModesAndMeans[i] = Utils.missingValue();
                    continue;
                }
                this.m_ModesAndMeans[i] = Utils.maxIndex((double[])counts[i]);
                continue;
            }
            if (!data.attribute(i).isNumeric() || !Utils.gr((double)sums[i], (double)0.0)) continue;
            this.m_ModesAndMeans[i] = results[i] / sums[i];
        }
        return new Instances(data, 0);
    }

    @Override
    protected Instance doImpute(Instance instance) throws Exception {
        DenseInstance inst = null;
        if (instance instanceof SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] indices = new int[instance.numValues()];
            int num = 0;
            for (int j = 0; j < instance.numValues(); ++j) {
                if (instance.isMissingSparse(j) && instance.classIndex() != instance.index(j) && (instance.attributeSparse(j).isNominal() || instance.attributeSparse(j).isNumeric())) {
                    if (this.m_ModesAndMeans[instance.index(j)] == 0.0) continue;
                    vals[num] = this.m_ModesAndMeans[instance.index(j)];
                    indices[num] = instance.index(j);
                    ++num;
                    continue;
                }
                vals[num] = instance.valueSparse(j);
                indices[num] = instance.index(j);
                ++num;
            }
            if (num == instance.numValues()) {
                inst = new SparseInstance(instance.weight(), vals, indices, instance.numAttributes());
            } else {
                double[] tempVals = new double[num];
                int[] tempInd = new int[num];
                System.arraycopy(vals, 0, tempVals, 0, num);
                System.arraycopy(indices, 0, tempInd, 0, num);
                inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
            }
        } else {
            double[] vals = new double[instance.numAttributes()];
            for (int j = 0; j < instance.numAttributes(); ++j) {
                vals[j] = instance.isMissing(j) && instance.classIndex() != j && (instance.attribute(j).isNominal() || instance.attribute(j).isNumeric()) ? this.m_ModesAndMeans[j] : instance.value(j);
            }
            inst = new DenseInstance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        return inst;
    }
}

