/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesimputation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesimputation.AbstractImputation;
import weka.filters.unsupervised.attribute.missingvaluesimputation.Imputation;
import weka.filters.unsupervised.attribute.missingvaluesimputation.NullImputation;

public class MultiImputation
extends AbstractImputation {
    public static final String ALGORITHM = "algorithm";
    protected Imputation[] m_Algorithms = this.getDefaultAlgorithms();

    @Override
    public String globalInfo() {
        return "Applies the specified imputation algorithms one after the other.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe imputation algorithms to use (can be supplied multiple times).", ALGORITHM, 1, "-algorithm <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (Imputation imp : this.m_Algorithms) {
            result.add("-algorithm");
            result.add("" + Utils.toCommandLine((Object)imp));
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        ArrayList<Imputation> imps = new ArrayList<Imputation>();
        do {
            if ((tmpStr = Utils.getOption((String)ALGORITHM, (String[])options)).isEmpty()) continue;
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            Imputation imp = (Imputation)Utils.forName(Imputation.class, (String)tmpStr, (String[])tmpOptions);
            imps.add(imp);
        } while (!tmpStr.isEmpty());
        if (imps.size() == 0) {
            imps.addAll(Arrays.asList(this.getDefaultAlgorithms()));
        }
        this.setAlgorithms(imps.toArray(new Imputation[imps.size()]));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected Imputation[] getDefaultAlgorithms() {
        return new Imputation[]{new NullImputation()};
    }

    public void setAlgorithms(Imputation[] value) {
        this.m_Algorithms = value;
    }

    public Imputation[] getAlgorithms() {
        return this.m_Algorithms;
    }

    public String algorithmsTipText() {
        return "The imputation algorithms to apply sequentially to the data.";
    }

    @Override
    protected Instances doBuildImputation(Instances data) throws Exception {
        Instances result = data;
        for (int i = 0; i < this.m_Algorithms.length; ++i) {
            try {
                result = this.m_Algorithms[i].buildImputation(result);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Algorithm #" + (i + 1) + " failed!", e);
            }
        }
        return result;
    }

    @Override
    protected Instance doImpute(Instance inst) throws Exception {
        Instance result = inst;
        for (int i = 0; i < this.m_Algorithms.length; ++i) {
            try {
                result = this.m_Algorithms[i].impute(result);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Algorithm #" + (i + 1) + " failed!", e);
            }
        }
        return result;
    }
}

