/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesimputation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.unsupervised.attribute.missingvaluesimputation.AbstractImputation;

public class SimpleNearestNeighbor
extends AbstractImputation {
    public static final String SEARCH = "search";
    public static final String NUM_NEIGHBORS = "num-neighbors";
    protected NearestNeighbourSearch m_Search = this.getDefaultSearch();
    protected int m_NumNeighbors = this.getDefaultNumNeighbors();
    protected Instances m_TrainingData;

    @Override
    public String globalInfo() {
        return "Uses the specified nearest neighbor search to determine the neighborhood from which it uses:\n- the most common label (nominal attributes)\n- the average in the neighborhood (numeric/date attributes)\nto replace missing values for the Instance currently being processed.\nIn case of ties for nominal attributes, the 'smaller' label (alphabetically speaking) wins.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\t" + this.searchTipText() + "\n" + "\t(default: " + this.getDefaultSearch().getClass().getName() + ")", SEARCH, 1, "-search <classname + options>"));
        result.addElement(new Option("\t" + this.numNeighborsTipText() + "\n" + "\t(default: " + this.getDefaultNumNeighbors() + ")", NUM_NEIGHBORS, 1, "-num-neighbors <int>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-search");
        result.add("" + Utils.toCommandLine((Object)this.m_Search));
        result.add("-num-neighbors");
        result.add("" + this.m_NumNeighbors);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)SEARCH, (String[])options);
        if (!tmpStr.isEmpty()) {
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            NearestNeighbourSearch search = (NearestNeighbourSearch)Utils.forName(NearestNeighbourSearch.class, (String)tmpStr, (String[])tmpOptions);
            this.setSearch(search);
        } else {
            this.setSearch(this.getDefaultSearch());
        }
        tmpStr = Utils.getOption((String)NUM_NEIGHBORS, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setNumNeighbors(Integer.parseInt(tmpStr));
        } else {
            this.setNumNeighbors(this.getDefaultNumNeighbors());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected NearestNeighbourSearch getDefaultSearch() {
        return new LinearNNSearch();
    }

    public void setSearch(NearestNeighbourSearch value) {
        this.m_Search = value;
    }

    public NearestNeighbourSearch getSearch() {
        return this.m_Search;
    }

    public String searchTipText() {
        return "The nearest neighbor search algorithm to use.";
    }

    protected int getDefaultNumNeighbors() {
        return 100;
    }

    public void setNumNeighbors(int value) {
        if (value > 0) {
            this.m_NumNeighbors = value;
        } else {
            System.err.println("Size of neighborhood must be > 0, provided: " + value);
        }
    }

    public int getNumNeighbors() {
        return this.m_NumNeighbors;
    }

    public String numNeighborsTipText() {
        return "The size of the neighborhood to use.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances doBuildImputation(Instances data) throws Exception {
        this.m_TrainingData = new Instances(data);
        this.m_Search.setInstances(this.m_TrainingData);
        return new Instances(data, 0);
    }

    protected double mean(List<Double> vector) {
        double sum = 0.0;
        if (vector.size() == 0) {
            return 0.0;
        }
        for (double element : vector) {
            sum += element;
        }
        return sum / (double)vector.size();
    }

    @Override
    protected Instance doImpute(Instance inst) throws Exception {
        int i;
        Instance result = inst;
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (i = 0; i < inst.numValues(); ++i) {
            if (!inst.isMissingSparse(i)) continue;
            missing.add(i);
        }
        if (missing.size() > 0) {
            result = (Instance)inst.copy();
            Instances closest = this.m_Search.kNearestNeighbours(inst, this.m_NumNeighbors);
            block5: for (i = 0; i < missing.size(); ++i) {
                Attribute att = inst.attributeSparse(((Integer)missing.get(i)).intValue());
                switch (att.type()) {
                    case 0: 
                    case 3: {
                        int n;
                        ArrayList<Double> values = new ArrayList<Double>();
                        for (n = 0; n < closest.numInstances(); ++n) {
                            if (closest.instance(n).isMissingSparse(((Integer)missing.get(i)).intValue())) continue;
                            values.add(closest.instance(n).valueSparse(((Integer)missing.get(i)).intValue()));
                        }
                        result.setValueSparse(((Integer)missing.get(i)).intValue(), this.mean(values));
                        continue block5;
                    }
                    case 1: {
                        String label;
                        int n;
                        HashMap<String, Integer> counts = new HashMap<String, Integer>();
                        for (n = 0; n < att.numValues(); ++n) {
                            counts.put(att.value(n), 0);
                        }
                        for (n = 0; n < closest.numInstances(); ++n) {
                            if (closest.instance(n).isMissingSparse(((Integer)missing.get(i)).intValue())) continue;
                            label = att.value((int)closest.instance(n).valueSparse(((Integer)missing.get(i)).intValue()));
                            counts.put(label, (Integer)counts.get(label) + 1);
                        }
                        int max = 0;
                        ArrayList labels = new ArrayList(counts.keySet());
                        label = (String)labels.get(0);
                        Collections.sort(labels);
                        for (String l : labels) {
                            if ((Integer)counts.get(l) > max) {
                                max = (Integer)counts.get(l);
                                label = l;
                            }
                            max = Math.max(max, (Integer)counts.get(l));
                        }
                        result.setValueSparse(((Integer)missing.get(i)).intValue(), (double)att.indexOfValue(label));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)att.type()));
                    }
                }
            }
        }
        return result;
    }
}

