/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesimputation;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesimputation.AbstractImputationWithRange;

public class UserSuppliedValues
extends AbstractImputationWithRange {
    public static final String NUMERIC = "numeric";
    public static final String DATE = "date";
    public static final String DATE_FORMAT = "date-format";
    public static final String NOMINAL = "nominal";
    protected double m_Numeric = this.getDefaultNumeric();
    protected String m_Date = this.getDefaultDate();
    protected String m_DateFormat = this.getDefaultDateFormat();
    protected long m_DateValue;
    protected SingleIndex m_Nominal = new SingleIndex(this.getDefaultNominal());

    @Override
    public String globalInfo() {
        return "Replaces missing values with the specified values on the selected range of attributes.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\t" + this.numericTipText() + "\n" + "\t(default: " + this.getDefaultNumeric() + ")", NUMERIC, 1, "-numeric <double>"));
        result.addElement(new Option("\t" + this.dateTipText() + "\n" + "\t(default: " + this.getDefaultDate() + ")", DATE, 1, "-date <string>"));
        result.addElement(new Option("\t" + this.dateFormatTipText() + "\n" + "\t(default: " + this.getDefaultDateFormat() + ")", DATE_FORMAT, 1, "-date-format <java.text.SimpleDateFormat string>"));
        result.addElement(new Option("\t" + this.nominalTipText() + "\n" + "\t(default: " + this.getDefaultNominal() + ")", NOMINAL, 1, "-nominal <string>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-numeric");
        result.add("" + this.m_Numeric);
        result.add("-date");
        result.add(this.m_Date);
        result.add("-date-format");
        result.add(this.m_DateFormat);
        result.add("-nominal");
        result.add(this.m_Nominal.getSingleIndex());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)NUMERIC, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setNumeric(Double.parseDouble(tmpStr));
        } else {
            this.setNumeric(this.getDefaultNumeric());
        }
        tmpStr = Utils.getOption((String)DATE, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setDate(tmpStr);
        } else {
            this.setDate(this.getDefaultDate());
        }
        tmpStr = Utils.getOption((String)DATE_FORMAT, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setDateFormat(tmpStr);
        } else {
            this.setDateFormat(this.getDefaultDateFormat());
        }
        tmpStr = Utils.getOption((String)NOMINAL, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setNominal(tmpStr);
        } else {
            this.setNominal(this.getDefaultNominal());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected double getDefaultNumeric() {
        return 0.0;
    }

    public void setNumeric(double value) {
        this.m_Numeric = value;
    }

    public double getNumeric() {
        return this.m_Numeric;
    }

    public String numericTipText() {
        return "The replacement value for missing values of numeric attributes.";
    }

    protected String getDefaultDate() {
        return "2000-01-01";
    }

    public void setDate(String value) {
        this.m_Date = value;
    }

    public String getDate() {
        return this.m_Date;
    }

    public String dateTipText() {
        return "The replacement value for missing values of date attributes.";
    }

    protected String getDefaultDateFormat() {
        return "yyyy-MM-dd";
    }

    public void setDateFormat(String value) {
        this.m_DateFormat = value;
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format string for parsing the date replacement value.";
    }

    protected String getDefaultNominal() {
        return "first";
    }

    public void setNominal(String value) {
        this.m_Nominal.setSingleIndex(value);
    }

    public String getNominal() {
        return this.m_Nominal.getSingleIndex();
    }

    public String nominalTipText() {
        return "The index of the label to use as replacement.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    protected Instances doBuildImputation(Instances data) throws Exception {
        SimpleDateFormat formatter = new SimpleDateFormat(this.m_DateFormat);
        this.m_DateValue = formatter.parse(this.m_Date).getTime();
        return new Instances(data, 0);
    }

    @Override
    protected Instance doImpute(Instance inst) throws Exception {
        int i;
        Instance result = (Instance)inst.copy();
        boolean missing = false;
        for (i = 0; i < inst.numValues(); ++i) {
            if (!inst.isMissingSparse(i)) continue;
            missing = true;
            break;
        }
        if (missing) {
            block6: for (i = 0; i < result.numValues(); ++i) {
                int index = result.index(i);
                if (!this.m_IndicesSet.contains(index) || !result.isMissingSparse(i)) continue;
                Attribute att = result.attributeSparse(i);
                switch (att.type()) {
                    case 0: {
                        result.setValueSparse(i, this.m_Numeric);
                        continue block6;
                    }
                    case 3: {
                        result.setValueSparse(i, (double)this.m_DateValue);
                        continue block6;
                    }
                    case 1: {
                        this.m_Nominal.setUpper(att.numValues() - 1);
                        result.setValueSparse(i, (double)this.m_Nominal.getIndex());
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled attribute type: " + Attribute.typeToString((int)att.type()));
                    }
                }
            }
        }
        return result;
    }
}

