/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesinjection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesinjection.AbstractInjection;

public abstract class AbstractInjectionWithRange
extends AbstractInjection {
    private static final long serialVersionUID = 3787465264006307917L;
    public static final String RANGE = "R";
    public static final String INVERT_MATCHING = "V";
    protected Range m_Cols = new Range(this.getDefaultAttributeIndices());
    protected int[] m_Indices;
    protected HashSet<Integer> m_IndicesSet;

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\t" + this.attributeIndicesTipText() + ".\n" + "\t(default: " + this.getDefaultAttributeIndices() + ")", RANGE, 1, "-R <col1,col2,...>"));
        result.addElement(new Option("\tInverts the matching sense.", INVERT_MATCHING, 0, "-V"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-R");
        result.add("" + this.m_Cols.getRanges());
        if (this.m_Cols.getInvert()) {
            result.add("-V");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)RANGE, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices(this.getDefaultAttributeIndices());
        }
        this.setInvertSelection(Utils.getFlag((String)INVERT_MATCHING, (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected String getDefaultAttributeIndices() {
        return "first-last";
    }

    public void setAttributeIndices(String value) {
        this.m_Cols.setRanges(value);
    }

    public String getAttributeIndices() {
        return this.m_Cols.getRanges();
    }

    public String attributeIndicesTipText() {
        return "The selection of columns to use in the injection process, 'first' and 'last' are valid indices.";
    }

    public void setInvertSelection(boolean value) {
        this.m_Cols.setInvert(value);
    }

    public boolean getInvertSelection() {
        return this.m_Cols.getInvert();
    }

    public String invertSelectionTipText() {
        return "If enabled the selection of the columns is inverted.";
    }

    @Override
    protected void initInjection(Instances data) {
        super.initInjection(data);
        this.m_Cols.setUpper(data.numAttributes() - 1);
        this.m_Indices = this.m_Cols.getSelection();
        this.m_IndicesSet = new HashSet();
        for (int index : this.m_Indices) {
            this.m_IndicesSet.add(index);
        }
    }
}

