/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesinjection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesinjection.AbstractInjection;
import weka.filters.unsupervised.attribute.missingvaluesinjection.Injection;
import weka.filters.unsupervised.attribute.missingvaluesinjection.NullInjection;

public class MultiInjection
extends AbstractInjection {
    public static final String ALGORITHM = "algorithm";
    protected Injection[] m_Algorithms = this.getDefaultAlgorithms();

    @Override
    public String globalInfo() {
        return "Applies the specified injection algorithms one after the other.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe injection algorithms to use (can be supplied multiple times).", ALGORITHM, 1, "-algorithm <classname + options>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        for (Injection imp : this.m_Algorithms) {
            result.add("-algorithm");
            result.add("" + Utils.toCommandLine((Object)imp));
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr;
        ArrayList<Injection> imps = new ArrayList<Injection>();
        do {
            if ((tmpStr = Utils.getOption((String)ALGORITHM, (String[])options)).isEmpty()) continue;
            String[] tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            Injection imp = (Injection)Utils.forName(Injection.class, (String)tmpStr, (String[])tmpOptions);
            imps.add(imp);
        } while (!tmpStr.isEmpty());
        if (imps.size() == 0) {
            imps.addAll(Arrays.asList(this.getDefaultAlgorithms()));
        }
        this.setAlgorithms(imps.toArray(new Injection[imps.size()]));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected Injection[] getDefaultAlgorithms() {
        return new Injection[]{new NullInjection()};
    }

    public void setAlgorithms(Injection[] value) {
        this.m_Algorithms = value;
    }

    public Injection[] getAlgorithms() {
        return this.m_Algorithms;
    }

    public String algorithmsTipText() {
        return "The injection algorithms to apply sequentially to the data.";
    }

    @Override
    protected Instances doBuildInjection(Instances data) throws Exception {
        Instances result = data;
        for (int i = 0; i < this.m_Algorithms.length; ++i) {
            try {
                result = this.m_Algorithms[i].buildInjection(result);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Algorithm #" + (i + 1) + " failed!", e);
            }
        }
        return result;
    }

    @Override
    protected Instance doInject(Instance inst) throws Exception {
        Instance result = inst;
        for (int i = 0; i < this.m_Algorithms.length; ++i) {
            try {
                result = this.m_Algorithms[i].inject(result);
                continue;
            }
            catch (Exception e) {
                throw new Exception("Algorithm #" + (i + 1) + " failed!", e);
            }
        }
        return result;
    }
}

