/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute.missingvaluesinjection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Randomizable;
import weka.core.Utils;
import weka.filters.unsupervised.attribute.missingvaluesinjection.AbstractInjectionWithRange;

public class RandomPercentage
extends AbstractInjectionWithRange
implements Randomizable {
    public static final String SEED = "seed";
    public static final String PERCENTAGE = "percentage";
    protected int m_Seed = this.getDefaultSeed();
    protected double m_Percentage = this.getDefaultPercentage();
    protected Random[] m_Random;

    @Override
    public String globalInfo() {
        return "Simple algorithm for setting random values to missing, using java.util.Random:\n- Initialization:\n  The seed value is used to initialize a random number that provides\n  seed value for a random number generator per attribute in selected\n  range using Random.nextInt().\n\n- Injection:\n  For each instance:\n    For each attribute in selected range:\n      If Random.nextDouble() is < supplied percentage set value to missing\n";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\t" + this.seedTipText() + ".\n" + "\t(default: " + this.getDefaultSeed() + ")", SEED, 1, "-seed <int>"));
        result.addElement(new Option("\t" + this.percentageTipText() + ".\n" + "\t(default: " + this.getDefaultPercentage() + ")", PERCENTAGE, 1, "-percentage <0.0-1.0>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-seed");
        result.add("" + this.m_Seed);
        result.add("-percentage");
        result.add("" + this.m_Percentage);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)SEED, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setSeed(Integer.parseInt(tmpStr));
        } else {
            this.setSeed(this.getDefaultSeed());
        }
        tmpStr = Utils.getOption((String)PERCENTAGE, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setPercentage(Double.parseDouble(tmpStr));
        } else {
            this.setPercentage(this.getDefaultPercentage());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected int getDefaultSeed() {
        return 1;
    }

    public void setSeed(int value) {
        this.m_Seed = value;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed value for initializing the random number generators.";
    }

    protected double getDefaultPercentage() {
        return 0.2;
    }

    public void setPercentage(double value) {
        if (value >= 0.0 && value <= 1.0) {
            this.m_Percentage = value;
        } else {
            System.err.println("Percentage must be 0 <= x <= 1, provided: " + value);
        }
    }

    public double getPercentage() {
        return this.m_Percentage;
    }

    public String percentageTipText() {
        return "The percentage of random numbers.";
    }

    @Override
    protected Instances doBuildInjection(Instances data) throws Exception {
        Random rand = new Random(this.m_Seed);
        this.m_Random = new Random[this.m_Indices.length];
        for (int i = 0; i < this.m_Random.length; ++i) {
            this.m_Random[i] = new Random(rand.nextInt());
        }
        return new Instances(data, 0);
    }

    @Override
    protected Instance doInject(Instance inst) throws Exception {
        Instance result = (Instance)inst.copy();
        for (int i = 0; i < this.m_Indices.length; ++i) {
            double val = this.m_Random[i].nextDouble();
            if (!(val < this.m_Percentage)) continue;
            result.setMissing(this.m_Indices[i]);
        }
        return result;
    }
}

