/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import weka.classifiers.meta.MultiSearch;
import weka.core.Instances;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.Point;

public abstract class AbstractEvaluationTask
implements Runnable {
    protected MultiSearch m_Owner;
    protected Instances m_Data;
    protected SetupGenerator m_Generator;
    protected Point<Object> m_Values;
    protected int m_Folds;
    protected int m_Evaluation;

    public AbstractEvaluationTask(MultiSearch owner, Instances inst, SetupGenerator generator, Point<Object> values, int folds, int eval) {
        this.m_Owner = owner;
        this.m_Data = inst;
        this.m_Generator = generator;
        this.m_Values = values;
        this.m_Folds = folds;
        this.m_Evaluation = eval;
    }

    protected abstract void doRun() throws Exception;

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Exception e) {
            System.err.println("Encountered exception while evaluating classifier, skipping!");
            System.err.println("- Values: " + this.m_Values);
            e.printStackTrace();
            this.m_Owner.completedEvaluation(this.m_Values, false);
        }
        this.cleanUp();
    }

    public void cleanUp() {
        this.m_Owner = null;
        this.m_Data = null;
        this.m_Generator = null;
        this.m_Values = null;
    }
}

