/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import weka.classifiers.Evaluation;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.classifiers.meta.multisearch.DefaultEvaluationMetrics;

public class DefaultEvaluationWrapper
extends AbstractEvaluationWrapper<Evaluation, DefaultEvaluationMetrics> {
    private static final long serialVersionUID = 931329614934902835L;
    protected Evaluation m_Evaluation;

    public DefaultEvaluationWrapper(Evaluation eval, DefaultEvaluationMetrics metrics) {
        super(eval, metrics);
    }

    @Override
    protected void setEvaluation(Evaluation eval) {
        this.m_Evaluation = eval;
    }

    @Override
    public double getMetric(int id) {
        try {
            switch (id) {
                case 7: {
                    return this.m_Evaluation.kappa();
                }
                case 6: {
                    return this.m_Evaluation.pctCorrect();
                }
                case 0: {
                    return this.m_Evaluation.correlationCoefficient();
                }
                case 5: {
                    return 1.0 - StrictMath.abs(this.m_Evaluation.correlationCoefficient()) + this.m_Evaluation.rootRelativeSquaredError() + this.m_Evaluation.relativeAbsoluteError();
                }
                case 3: {
                    return this.m_Evaluation.meanAbsoluteError();
                }
                case 4: {
                    return this.m_Evaluation.relativeAbsoluteError();
                }
                case 1: {
                    return this.m_Evaluation.rootMeanSquaredError();
                }
                case 2: {
                    return this.m_Evaluation.rootRelativeSquaredError();
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

