/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.HashMap;
import weka.classifiers.meta.multisearch.AbstractEvaluationMetrics;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.core.Tag;
import weka.core.setupgenerator.Point;

public class Performance
implements Serializable {
    private static final long serialVersionUID = -4374706475277588755L;
    protected Point<Object> m_Values;
    protected int m_Evaluation;
    protected AbstractEvaluationMetrics m_Metrics;
    protected HashMap<Integer, Double> m_MetricValues;

    public Performance(Point<Object> values, AbstractEvaluationWrapper evaluation, int evalType) throws Exception {
        this.m_Values = values;
        this.m_Evaluation = evalType;
        this.m_MetricValues = new HashMap();
        this.m_Metrics = null;
        if (evaluation != null) {
            this.m_Metrics = evaluation.getMetrics();
            for (Tag tag : ((AbstractEvaluationMetrics)evaluation.getMetrics()).getTags()) {
                this.m_MetricValues.put(tag.getID(), evaluation.getMetric(tag));
            }
        }
    }

    public int getEvaluation() {
        return this.m_Evaluation;
    }

    public double getPerformance() {
        return this.getPerformance(this.m_Evaluation);
    }

    public void setPerformance(int evaluation, double value) {
        if (this.m_Metrics != null && !this.m_Metrics.check(evaluation)) {
            return;
        }
        this.m_MetricValues.put(evaluation, value);
    }

    public double getPerformance(int evaluation) {
        if (this.m_Metrics != null && !this.m_Metrics.check(evaluation)) {
            return Double.NaN;
        }
        if (!this.m_MetricValues.containsKey(evaluation)) {
            return Double.NaN;
        }
        return this.m_MetricValues.get(evaluation);
    }

    public Point<Object> getValues() {
        return this.m_Values;
    }

    public String toString() {
        String evalStr = null;
        if (this.m_Metrics != null) {
            for (Tag tag : this.m_Metrics.getTags()) {
                if (tag.getID() != this.m_Evaluation) continue;
                evalStr = tag.getIDStr();
                break;
            }
        }
        if (evalStr == null) {
            evalStr = "" + this.m_Evaluation;
        }
        String result = "Performance (" + this.getValues() + "): ";
        result = result + this.getPerformance() + " (" + evalStr + ")";
        return result;
    }
}

