/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.MultiSearch;
import weka.classifiers.meta.multisearch.AbstractEvaluationTask;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.classifiers.meta.multisearch.Performance;
import weka.core.Instances;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.Point;

public class DefaultEvaluationTask
extends AbstractEvaluationTask {
    public DefaultEvaluationTask(MultiSearch owner, Instances inst, SetupGenerator generator, Point<Object> values, int folds, int eval) {
        super(owner, inst, generator, values, folds, eval);
    }

    @Override
    protected void doRun() throws Exception {
        boolean completed;
        Evaluation eval;
        Point<Object> evals = this.m_Generator.evaluate(this.m_Values);
        MultiSearch multi = (MultiSearch)((Object)this.m_Generator.setup((Serializable)((Object)this.m_Owner), evals));
        Classifier classifier = multi.getClassifier();
        try {
            eval = new Evaluation(this.m_Data);
            eval.setDiscardPredictions(true);
            if (this.m_Folds >= 2) {
                eval.crossValidateModel(classifier, this.m_Data, this.m_Folds, new Random(this.m_Owner.getSeed()), new Object[0]);
            } else {
                classifier.buildClassifier(this.m_Data);
                eval.evaluateModel(classifier, this.m_Data, new Object[0]);
            }
            completed = true;
        }
        catch (Exception e) {
            eval = null;
            System.err.println("Encountered exception while evaluating classifier, skipping!");
            System.err.println("- Classifier: " + this.m_Owner.getCommandline(classifier));
            e.printStackTrace();
            completed = false;
        }
        Performance performance = new Performance(this.m_Values, (AbstractEvaluationWrapper)this.m_Owner.getFactory().newWrapper(eval), this.m_Evaluation);
        this.m_Owner.addPerformance(performance, this.m_Folds);
        this.m_Owner.log(performance + ": cached=false");
        this.m_Owner.completedEvaluation(classifier, completed);
    }
}

