/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import weka.classifiers.meta.MultiSearch;
import weka.classifiers.meta.multisearch.AbstractMultiThreadedSearch;
import weka.core.Instances;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.Point;

public abstract class AbstractEvaluationTask
implements Runnable {
    protected MultiSearch m_Owner;
    protected Instances m_Train;
    protected Instances m_Test;
    protected SetupGenerator m_Generator;
    protected Point<Object> m_Values;
    protected int m_Folds;
    protected int m_Evaluation;

    public AbstractEvaluationTask(MultiSearch owner, Instances train, Instances test, SetupGenerator generator, Point<Object> values, int folds, int eval) {
        String msg;
        this.m_Owner = owner;
        this.m_Train = train;
        this.m_Test = test;
        this.m_Generator = generator;
        this.m_Values = values;
        this.m_Folds = folds;
        this.m_Evaluation = eval;
        if (this.m_Test != null && (msg = this.m_Train.equalHeadersMsg(this.m_Test)) != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    protected abstract void doRun() throws Exception;

    @Override
    public void run() {
        block2: {
            try {
                this.doRun();
            }
            catch (Exception e) {
                System.err.println("Encountered exception while evaluating classifier, skipping!");
                System.err.println("- Values: " + this.m_Values);
                e.printStackTrace();
                if (!(this.m_Owner.getAlgorithm() instanceof AbstractMultiThreadedSearch)) break block2;
                ((AbstractMultiThreadedSearch)this.m_Owner.getAlgorithm()).completedEvaluation(this.m_Values, false);
            }
        }
        this.cleanUp();
    }

    public void cleanUp() {
        this.m_Owner = null;
        this.m_Train = null;
        this.m_Test = null;
        this.m_Generator = null;
        this.m_Values = null;
    }
}

