/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import weka.classifiers.Evaluation;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.classifiers.meta.multisearch.DefaultEvaluationMetrics;

public class DefaultEvaluationWrapper
extends AbstractEvaluationWrapper<Evaluation, DefaultEvaluationMetrics> {
    private static final long serialVersionUID = 931329614934902835L;
    protected Evaluation m_Evaluation;

    public DefaultEvaluationWrapper(Evaluation eval, DefaultEvaluationMetrics metrics) {
        super(eval, metrics);
    }

    @Override
    protected void setEvaluation(Evaluation eval) {
        this.m_Evaluation = eval;
    }

    @Override
    public double getMetric(int id) {
        try {
            switch (id) {
                case 0: {
                    return this.m_Evaluation.correlationCoefficient();
                }
                case 14: {
                    return this.m_Evaluation.matthewsCorrelationCoefficient(0);
                }
                case 1: {
                    return this.m_Evaluation.rootMeanSquaredError();
                }
                case 2: {
                    return this.m_Evaluation.rootRelativeSquaredError();
                }
                case 3: {
                    return this.m_Evaluation.meanAbsoluteError();
                }
                case 4: {
                    return this.m_Evaluation.relativeAbsoluteError();
                }
                case 5: {
                    return 1.0 - StrictMath.abs(this.m_Evaluation.correlationCoefficient()) + this.m_Evaluation.rootRelativeSquaredError() + this.m_Evaluation.relativeAbsoluteError();
                }
                case 6: {
                    return this.m_Evaluation.pctCorrect();
                }
                case 7: {
                    return this.m_Evaluation.kappa();
                }
                case 15: {
                    return this.m_Evaluation.precision(0);
                }
                case 16: {
                    return this.m_Evaluation.weightedPrecision();
                }
                case 17: {
                    return this.m_Evaluation.recall(0);
                }
                case 18: {
                    return this.m_Evaluation.weightedRecall();
                }
                case 8: {
                    return this.m_Evaluation.areaUnderROC(0);
                }
                case 9: {
                    return this.m_Evaluation.weightedAreaUnderROC();
                }
                case 10: {
                    return this.m_Evaluation.areaUnderPRC(0);
                }
                case 11: {
                    return this.m_Evaluation.weightedAreaUnderPRC();
                }
                case 12: {
                    return this.m_Evaluation.fMeasure(0);
                }
                case 13: {
                    return this.m_Evaluation.weightedFMeasure();
                }
                case 19: {
                    return this.m_Evaluation.truePositiveRate(0);
                }
                case 20: {
                    return this.m_Evaluation.trueNegativeRate(0);
                }
                case 21: {
                    return this.m_Evaluation.falsePositiveRate(0);
                }
                case 22: {
                    return this.m_Evaluation.falseNegativeRate(0);
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }
}

