/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.HashMap;
import weka.classifiers.Classifier;
import weka.classifiers.meta.multisearch.AbstractEvaluationMetrics;
import weka.classifiers.meta.multisearch.AbstractEvaluationWrapper;
import weka.core.Tag;
import weka.core.setupgenerator.Point;

public class Performance
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4374706475277588755L;
    protected Point<Object> m_Values;
    protected int m_Evaluation;
    protected AbstractEvaluationMetrics m_Metrics;
    protected HashMap<Integer, Double> m_MetricValues;
    protected Classifier m_Classifier;

    protected Performance() {
    }

    public Performance(Point<Object> values, AbstractEvaluationWrapper evaluation, int evalType, Classifier classifier) throws Exception {
        this();
        this.m_Values = values;
        this.m_Evaluation = evalType;
        this.m_MetricValues = new HashMap();
        this.m_Metrics = null;
        this.m_Classifier = classifier;
        if (evaluation != null) {
            this.m_Metrics = evaluation.getMetrics();
            for (Tag tag : ((AbstractEvaluationMetrics)evaluation.getMetrics()).getTags()) {
                this.m_MetricValues.put(tag.getID(), evaluation.getMetric(tag));
            }
        }
    }

    public Object clone() {
        Performance result = new Performance();
        result.m_Values = (Point)this.m_Values.clone();
        result.m_Evaluation = this.m_Evaluation;
        result.m_Metrics = this.m_Metrics;
        result.m_MetricValues = (HashMap)this.m_MetricValues.clone();
        result.m_Classifier = this.m_Classifier;
        return result;
    }

    public int getEvaluation() {
        return this.m_Evaluation;
    }

    public double getPerformance() {
        return this.getPerformance(this.m_Evaluation);
    }

    public void setPerformance(int evaluation, double value) {
        if (this.m_Metrics != null && !this.m_Metrics.check(evaluation)) {
            return;
        }
        this.m_MetricValues.put(evaluation, value);
    }

    public double getPerformance(int evaluation) {
        if (this.m_Metrics != null && !this.m_Metrics.check(evaluation)) {
            return Double.NaN;
        }
        if (!this.m_MetricValues.containsKey(evaluation)) {
            return Double.NaN;
        }
        return this.m_MetricValues.get(evaluation);
    }

    public Point<Object> getValues() {
        return this.m_Values;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public String toString() {
        String evalStr = null;
        if (this.m_Metrics != null) {
            for (Tag tag : this.m_Metrics.getTags()) {
                if (tag.getID() != this.m_Evaluation) continue;
                evalStr = tag.getIDStr();
                break;
            }
        }
        if (evalStr == null) {
            evalStr = "" + this.m_Evaluation;
        }
        String result = "Performance (" + this.getValues() + "): ";
        result = result + this.getPerformance() + " (" + evalStr + ")";
        return result;
    }
}

