/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.Callable;
import weka.classifiers.meta.multisearch.MultiSearchCapable;
import weka.core.Instances;
import weka.core.SetupGenerator;
import weka.core.setupgenerator.Point;

public abstract class AbstractEvaluationTask
implements Callable {
    protected MultiSearchCapable m_Owner;
    protected Instances m_Train;
    protected Instances m_Test;
    protected SetupGenerator m_Generator;
    protected Point<Object> m_Values;
    protected int m_Folds;
    protected int m_Evaluation;
    protected int m_ClassLabel;
    protected Exception m_Exception;

    public AbstractEvaluationTask(MultiSearchCapable owner, Instances train, Instances test, SetupGenerator generator, Point<Object> values, int folds, int eval, int classLabel) {
        String msg;
        this.m_Owner = owner;
        this.m_Train = train;
        this.m_Test = test;
        this.m_Generator = generator;
        this.m_Values = values;
        this.m_Folds = folds;
        this.m_Evaluation = eval;
        this.m_ClassLabel = classLabel;
        this.m_Exception = null;
        if (this.m_Test != null && (msg = this.m_Train.equalHeadersMsg(this.m_Test)) != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    protected abstract Boolean doRun() throws Exception;

    public Boolean call() throws Exception {
        Boolean result;
        try {
            result = this.doRun();
        }
        catch (Exception e) {
            this.m_Exception = e;
            throw e;
        }
        finally {
            this.cleanUp();
        }
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        this.m_Train = null;
        this.m_Test = null;
        this.m_Generator = null;
        this.m_Values = null;
    }

    public String toString() {
        if (this.m_Exception != null) {
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            this.m_Exception.printStackTrace(pwriter);
            pwriter.flush();
            pwriter.close();
            return "Error:\n" + swriter.toString();
        }
        return "No error";
    }
}

