/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import weka.classifiers.meta.multisearch.AbstractSearch;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class AbstractMultiThreadedSearch
extends AbstractSearch {
    protected int m_NumExecutionSlots = 1;
    protected transient ExecutorService m_ExecutorPool;

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-num-slots");
        result.add("" + this.getNumExecutionSlots());
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"num-slots", (String[])options);
        if (tmpStr.length() != 0) {
            this.setNumExecutionSlots(Integer.parseInt(tmpStr));
        } else {
            this.setNumExecutionSlots(1);
        }
        super.setOptions(options);
    }

    public void setNumExecutionSlots(int value) {
        if (value >= 1) {
            this.m_NumExecutionSlots = value;
        }
    }

    public int getNumExecutionSlots() {
        return this.m_NumExecutionSlots;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for constructing the ensemble.";
    }

    protected void startExecutorPool() {
        this.stopExecutorPool();
        this.log("Starting thread pool with " + this.m_NumExecutionSlots + " slots...");
        this.m_ExecutorPool = Executors.newFixedThreadPool(this.m_NumExecutionSlots);
    }

    protected void stopExecutorPool() {
        this.log("Shutting down thread pool...");
        if (this.m_ExecutorPool != null) {
            this.m_ExecutorPool.shutdownNow();
        }
        this.m_ExecutorPool = null;
    }

    @Override
    public void preSearch(Instances data) throws Exception {
        super.preSearch(data);
        if (this.m_Debug) {
            System.out.println("Starting executor pool.");
        }
        this.startExecutorPool();
    }

    @Override
    public void cleanUpSearch() {
        super.cleanUpSearch();
        if (this.m_Debug) {
            System.out.println("Stopping executor pool.");
        }
        this.stopExecutorPool();
    }
}

