/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.functions.LinearRegression;
import weka.classifiers.meta.multisearch.AbstractEvaluationFactory;
import weka.classifiers.meta.multisearch.AbstractEvaluationMetrics;
import weka.classifiers.meta.multisearch.AbstractSearch;
import weka.classifiers.meta.multisearch.DefaultEvaluationFactory;
import weka.classifiers.meta.multisearch.DefaultSearch;
import weka.classifiers.meta.multisearch.MultiSearchCapable;
import weka.classifiers.meta.multisearch.Performance;
import weka.classifiers.meta.multisearch.PerformanceComparator;
import weka.classifiers.meta.multisearch.TraceableOptimizer;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Debug;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PropertyPath;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.SerializedObject;
import weka.core.SetupGenerator;
import weka.core.SingleIndex;
import weka.core.Summarizable;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.setupgenerator.AbstractParameter;
import weka.core.setupgenerator.AbstractPropertyParameter;
import weka.core.setupgenerator.MathParameter;
import weka.core.setupgenerator.ParameterGroup;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.Space;

public class MultiSearch
extends RandomizableSingleClassifierEnhancer
implements MultiSearchCapable,
AdditionalMeasureProducer,
Summarizable,
TraceableOptimizer {
    private static final long serialVersionUID = -5129316523575906233L;
    protected AbstractSearch.SearchResult m_BestClassifier;
    protected AbstractEvaluationFactory m_Factory;
    protected AbstractEvaluationMetrics m_Metrics;
    protected int m_Evaluation;
    protected SingleIndex m_ClassLabel;
    protected File m_LogFile = new File(System.getProperty("user.dir"));
    protected AbstractParameter[] m_DefaultParameters;
    protected AbstractParameter[] m_Parameters;
    protected AbstractSearch m_Algorithm;
    protected SetupGenerator m_Generator;
    protected List<Map.Entry<Integer, Performance>> m_Trace;

    public MultiSearch() {
        this.m_Factory = this.newFactory();
        this.m_Metrics = this.m_Factory.newMetrics();
        this.m_Evaluation = this.m_Metrics.getDefaultMetric();
        this.m_ClassLabel = new SingleIndex("1");
        this.m_Classifier = this.defaultClassifier();
        this.m_DefaultParameters = this.defaultSearchParameters();
        this.m_Parameters = this.defaultSearchParameters();
        this.m_Algorithm = this.defaultAlgorithm();
        this.m_Trace = new ArrayList<Map.Entry<Integer, Performance>>();
        try {
            this.m_BestClassifier = new AbstractSearch.SearchResult();
            this.m_BestClassifier.classifier = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
        }
        catch (Exception e) {
            System.err.println("Failed to create copy of default classifier!");
            e.printStackTrace();
        }
    }

    public String globalInfo() {
        return "Performs a search of an arbitrary number of parameters of a classifier and chooses the best pair found for the actual filtering and training.\nThe default MultiSearch is using the following Classifier setup:\n  LinearRegression, searching for the \"Ridge\"\nThe properties being explored are totally up to the user.\n\nE.g., if you have a FilteredClassifier selected as base classifier, sporting a PLSFilter and you want to explore the number of PLS components, then your property will be made up of the following components:\n - filter: referring to the FilteredClassifier's property (= PLSFilter)\n - numComponents: the actual property of the PLSFilter that we want to modify\nAnd assembled, the property looks like this:\n  filter.numComponents\n\n\nThe best classifier setup can be accessed after the buildClassifier call via the getBestClassifier method.\n\nThe trace of setups evaluated can be accessed after the buildClassifier call as well, using the following methods:\n- getTrace()\n- getTraceSize()\n- getTraceValue(int)\n- getTraceFolds(int)\n- getTraceClassifierAsCli(int)\n- getTraceParameterSettings(int)\n\nUsing the " + ParameterGroup.class.getName() + " parameter, it is possible to group dependent parameters. In this case, all top-level parameters must be of type " + ParameterGroup.class.getName() + ".";
    }

    protected String defaultClassifierString() {
        return this.defaultClassifier().getClass().getName();
    }

    protected Classifier defaultClassifier() {
        LinearRegression result = new LinearRegression();
        result.setAttributeSelectionMethod(new SelectedTag(1, LinearRegression.TAGS_SELECTION));
        result.setEliminateColinearAttributes(false);
        return result;
    }

    protected AbstractParameter[] defaultSearchParameters() {
        AbstractParameter[] result = new AbstractParameter[1];
        MathParameter param = new MathParameter();
        param.setProperty("ridge");
        param.setMin(-10.0);
        param.setMax(5.0);
        param.setStep(1.0);
        param.setBase(10.0);
        param.setExpression("pow(BASE,I)");
        result[0] = param;
        try {
            result = (AbstractParameter[])new SerializedObject((Object)result).getObject();
        }
        catch (Exception e) {
            result = new AbstractParameter[]{};
            System.err.println("Failed to create copy of default parameters!");
            e.printStackTrace();
        }
        return result;
    }

    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        String desc = "";
        for (int i = 0; i < this.m_Metrics.getTags().length; ++i) {
            SelectedTag tag = new SelectedTag(this.m_Metrics.getTags()[i].getID(), this.m_Metrics.getTags());
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tDetermines the parameter used for evaluation:\n" + desc + "\t(default: " + new SelectedTag(this.m_Metrics.getDefaultMetric(), this.m_Metrics.getTags()) + ")", "E", 1, "-E " + Tag.toOptionList((Tag[])this.m_Metrics.getTags())));
        result.addElement(new Option("\tThe class label index to retrieve the metric for (if applicable).\n", "class-label", 1, "-class-label \"<1-based index>\""));
        result.addElement(new Option("\tA property search setup.\n", "search", 1, "-search \"<classname options>\""));
        result.addElement(new Option("\tA search algorithm.\n", "algorithm", 1, "-algorithm \"<classname options>\""));
        result.addElement(new Option("\tThe log file to log the messages to.\n\t(default: none)", "log-file", 1, "-log-file <filename>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    public String[] getOptions() {
        int i;
        Vector<String> result = new Vector<String>();
        result.add("-E");
        result.add("" + this.getEvaluation());
        for (i = 0; i < this.getSearchParameters().length; ++i) {
            result.add("-search");
            result.add(this.getCommandline(this.getSearchParameters()[i]));
        }
        result.add("-class-label");
        result.add(this.getClassLabel());
        result.add("-algorithm");
        result.add(this.getCommandline(this.m_Algorithm));
        result.add("-log-file");
        result.add("" + this.getLogFile());
        String[] options = super.getOptions();
        for (i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String[] tmpOptions;
        int i;
        String tmpStr = Utils.getOption((char)'E', (String[])options);
        if (tmpStr.length() != 0) {
            this.setEvaluation(new SelectedTag(tmpStr, this.m_Metrics.getTags()));
        } else {
            this.setEvaluation(new SelectedTag(this.m_Metrics.getDefaultMetric(), this.m_Metrics.getTags()));
        }
        Vector<String> search = new Vector<String>();
        do {
            if ((tmpStr = Utils.getOption((String)"search", (String[])options)).length() <= 0) continue;
            search.add(tmpStr);
        } while (tmpStr.length() > 0);
        if (search.size() == 0) {
            for (i = 0; i < this.m_DefaultParameters.length; ++i) {
                search.add(this.getCommandline(this.m_DefaultParameters[i]));
            }
        }
        AbstractParameter[] params = new AbstractParameter[search.size()];
        for (i = 0; i < search.size(); ++i) {
            tmpOptions = Utils.splitOptions((String)((String)search.get(i)));
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            params[i] = (AbstractParameter)Utils.forName(AbstractParameter.class, (String)tmpStr, (String[])tmpOptions);
        }
        this.setSearchParameters(params);
        tmpStr = Utils.getOption((String)"class-label", (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setClassLabel(tmpStr);
        } else {
            this.setClassLabel("1");
        }
        tmpStr = Utils.getOption((String)"algorithm", (String[])options);
        if (!tmpStr.isEmpty()) {
            tmpOptions = Utils.splitOptions((String)tmpStr);
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setAlgorithm((AbstractSearch)Utils.forName(AbstractSearch.class, (String)tmpStr, (String[])tmpOptions));
        } else {
            this.setAlgorithm(new DefaultSearch());
        }
        tmpStr = Utils.getOption((String)"log-file", (String[])options);
        if (tmpStr.length() != 0) {
            this.setLogFile(new File(tmpStr));
        } else {
            this.setLogFile(new File(System.getProperty("user.dir")));
        }
        super.setOptions(options);
    }

    public void setClassifier(Classifier newClassifier) {
        super.setClassifier(newClassifier);
        try {
            this.m_BestClassifier.classifier = AbstractClassifier.makeCopy((Classifier)this.m_Classifier);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String searchParametersTipText() {
        return "Defines the search parameters.";
    }

    public void setSearchParameters(AbstractParameter[] value) {
        this.m_Parameters = value;
    }

    public AbstractParameter[] getSearchParameters() {
        return this.m_Parameters;
    }

    public String algorithmTipText() {
        return "Defines the search algorithm.";
    }

    public void setAlgorithm(AbstractSearch value) {
        this.m_Algorithm = value;
    }

    @Override
    public AbstractSearch getAlgorithm() {
        return this.m_Algorithm;
    }

    public String classLabelTipText() {
        return "The class label index (1-based) to retrieve the metrics for (if applicable).";
    }

    public void setClassLabel(String value) {
        this.m_ClassLabel.setSingleIndex(value);
    }

    public String getClassLabel() {
        return this.m_ClassLabel.getSingleIndex();
    }

    @Override
    public int getClassLabelIndex(int upper) {
        SingleIndex index = new SingleIndex(this.m_ClassLabel.getSingleIndex());
        index.setUpper(upper);
        return index.getIndex();
    }

    public AbstractSearch defaultAlgorithm() {
        DefaultSearch result = new DefaultSearch();
        return result;
    }

    public String evaluationTipText() {
        return "Sets the criterion for evaluating the classifier performance and choosing the best one.";
    }

    public Tag[] getMetricsTags() {
        return this.m_Metrics.getTags();
    }

    public void setEvaluation(SelectedTag value) {
        if (value.getTags() == this.m_Metrics.getTags()) {
            this.m_Evaluation = value.getSelectedTag().getID();
        }
    }

    @Override
    public SelectedTag getEvaluation() {
        return new SelectedTag(this.m_Evaluation, this.m_Metrics.getTags());
    }

    public String logFileTipText() {
        return "The log file to log the messages to.";
    }

    public File getLogFile() {
        return this.m_LogFile;
    }

    public void setLogFile(File value) {
        this.m_LogFile = value;
    }

    @Override
    public Classifier getBestClassifier() {
        return this.m_BestClassifier.classifier;
    }

    @Override
    public SetupGenerator getGenerator() {
        return this.m_Generator;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        if (this.getBestValues() != null) {
            for (int i = 0; i < this.getBestValues().dimensions(); ++i) {
                if (!(this.getBestValues().getValue(i) instanceof Double)) continue;
                result.add("measure-" + i);
            }
        }
        return result.elements();
    }

    public double getMeasure(String measureName) {
        if (measureName.startsWith("measure-")) {
            return (Double)this.getBestValues().getValue(Integer.parseInt(measureName.replace("measure-", "")));
        }
        throw new IllegalArgumentException("Measure '" + measureName + "' not supported!");
    }

    protected AbstractEvaluationFactory newFactory() {
        return new DefaultEvaluationFactory();
    }

    @Override
    public AbstractEvaluationFactory getFactory() {
        return this.m_Factory;
    }

    @Override
    public AbstractEvaluationMetrics getMetrics() {
        return this.m_Metrics;
    }

    @Override
    public Point<Object> getBestValues() {
        return this.m_BestClassifier.values;
    }

    @Override
    public Point<Object> getBestCoordinates() {
        return this.m_BestClassifier.performance.getValues();
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        Capabilities classes = result.getClassCapabilities();
        Iterator iter = classes.capabilities();
        while (iter.hasNext()) {
            Capabilities.Capability capab = (Capabilities.Capability)iter.next();
            if (capab == Capabilities.Capability.BINARY_CLASS || capab == Capabilities.Capability.NOMINAL_CLASS || capab == Capabilities.Capability.NUMERIC_CLASS || capab == Capabilities.Capability.DATE_CLASS) continue;
            result.disable(capab);
        }
        for (Capabilities.Capability cap : Capabilities.Capability.values()) {
            result.enableDependency(cap);
        }
        if (result.getMinimumNumberInstances() < 1) {
            result.setMinimumNumberInstances(1);
        }
        result.setOwner((CapabilitiesHandler)this);
        return result;
    }

    @Override
    public String getCommandline(Object obj) {
        String result = obj.getClass().getName();
        if (obj instanceof OptionHandler) {
            result = result + " " + Utils.joinOptions((String[])((OptionHandler)obj).getOptions());
        }
        return result.trim();
    }

    @Override
    public void log(String message) {
        this.log(message, false);
    }

    @Override
    public void log(String message, boolean onlyLog) {
        if (this.getDebug() && !onlyLog) {
            System.out.println(message);
        }
        if (!this.getLogFile().isDirectory()) {
            Debug.writeToFile((String)this.getLogFile().getAbsolutePath(), (String)message, (boolean)true);
        }
    }

    @Override
    public String logPerformances(Space space, Vector<Performance> performances, Tag type) {
        StringBuffer result = new StringBuffer(type.getReadable() + ":\n");
        result.append(space.toString());
        result.append("\n");
        for (int i = 0; i < performances.size(); ++i) {
            result.append(performances.get(i).getPerformance(type.getID()));
            result.append("\n");
        }
        result.append("\n");
        return result.toString();
    }

    @Override
    public void logPerformances(Space space, Vector<Performance> performances) {
        for (int i = 0; i < this.m_Metrics.getTags().length; ++i) {
            this.log("\n" + this.logPerformances(space, performances, this.m_Metrics.getTags()[i]), true);
        }
    }

    @Override
    public int getTraceSize() {
        return this.m_Trace.size();
    }

    @Override
    public String getTraceClassifierAsCli(int index) {
        return this.getCommandline(this.m_Trace.get(index).getValue().getClassifier());
    }

    @Override
    public Double getTraceValue(int index) {
        return this.m_Trace.get(index).getValue().getPerformance();
    }

    @Override
    public List<Map.Entry<String, Object>> getTraceParameterSettings(int index) {
        ArrayList<Map.Entry<String, Object>> parameterSettings = new ArrayList<Map.Entry<String, Object>>();
        List<String> dimensions = this.m_Algorithm.getSearchDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            String parameter = dimensions.get(i);
            Object value = this.m_Trace.get(index).getValue().getValues().getValue(i);
            AbstractMap.SimpleEntry<String, Object> current = new AbstractMap.SimpleEntry<String, Object>(parameter, value);
            parameterSettings.add(i, current);
        }
        return parameterSettings;
    }

    @Override
    public Integer getTraceFolds(int index) {
        return this.m_Trace.get(index).getKey();
    }

    @Override
    public List<Map.Entry<Integer, Performance>> getTrace() {
        return this.m_Trace;
    }

    protected List<AbstractParameter[]> groupParameters() {
        int i;
        ArrayList<AbstractParameter[]> result = new ArrayList<AbstractParameter[]>();
        int groupCount = 0;
        for (i = 0; i < this.m_Parameters.length; ++i) {
            if (!(this.m_Parameters[i] instanceof ParameterGroup)) continue;
            ++groupCount;
        }
        if (groupCount > 0 && this.m_Parameters.length != groupCount) {
            throw new IllegalStateException("Cannot mix " + ParameterGroup.class.getName() + " with other parameter types!");
        }
        if (groupCount > 0) {
            for (i = 0; i < this.m_Parameters.length; ++i) {
                result.add(((ParameterGroup)this.m_Parameters[i]).getParameters());
            }
        } else {
            result.add(this.m_Parameters);
        }
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        AbstractSearch.SearchResult result;
        int i;
        this.m_Trace.clear();
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        List<AbstractParameter[]> groups = this.groupParameters();
        StringBuilder invalid = new StringBuilder();
        for (i = 0; i < groups.size(); ++i) {
            for (int n = 0; n < groups.get(i).length; ++n) {
                if (PropertyPath.find((Object)this.getClassifier(), (PropertyPath.Path)new PropertyPath.Path(((AbstractPropertyParameter)this.m_Parameters[i]).getProperty())) != null) continue;
                if (invalid.length() > 0) {
                    invalid.append("\n");
                }
                invalid.append("- group " + (i + 1) + ", parameter " + (n + 1) + ": ").append(((AbstractPropertyParameter)this.m_Parameters[i]).getProperty());
            }
        }
        if (invalid.length() > 0) {
            throw new Exception("Property path(s) in parameter(s) are invalid:\n" + invalid);
        }
        ArrayList<AbstractSearch.SearchResult> results = new ArrayList<AbstractSearch.SearchResult>();
        for (i = 0; i < groups.size(); ++i) {
            if (groups.size() > 1) {
                this.log("\n---> group #" + (i + 1));
            }
            this.m_Generator = new SetupGenerator();
            this.m_Generator.setBaseObject((Serializable)((Object)this));
            this.m_Generator.setParameters((AbstractParameter[])groups.get(i).clone());
            this.m_Generator.setBaseObject((Serializable)this.getClassifier());
            this.m_Algorithm.setOwner(this);
            result = this.m_Algorithm.search(data);
            results.add(result);
            this.m_Trace.addAll(this.m_Algorithm.getTrace());
        }
        result = (AbstractSearch.SearchResult)results.get(0);
        if (results.size() > 1) {
            PerformanceComparator comp = new PerformanceComparator(this.getEvaluation().getSelectedTag().getID(), this.getMetrics());
            for (i = 1; i < results.size(); ++i) {
                if (comp.compare(((AbstractSearch.SearchResult)results.get((int)i)).performance, result.performance) >= 0) continue;
                result = (AbstractSearch.SearchResult)results.get(i);
            }
        }
        this.m_BestClassifier = result;
        this.log("\n---> train best - start");
        this.log(Utils.toCommandLine((Object)this.m_BestClassifier));
        this.m_Classifier = AbstractClassifier.makeCopy((Classifier)this.m_BestClassifier.classifier);
        this.m_Classifier.buildClassifier(data);
        this.log("\n---> train best - end");
        if (this.m_Debug) {
            this.log("\n---> Trace (format: #. folds/performance - setup)");
            for (i = 0; i < this.getTraceSize(); ++i) {
                this.log(i + 1 + ". " + this.getTraceFolds(i) + "/" + this.getTraceValue(i) + " - " + this.getTraceClassifierAsCli(i));
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_Classifier.distributionForInstance(instance);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.getBestValues() == null) {
            result.append("No search performed yet.");
        } else {
            int i;
            result.append(this.getClass().getName() + ":\nClassifier: " + this.getCommandline(this.getBestClassifier()) + "\n\n");
            for (i = 0; i < this.m_Parameters.length; ++i) {
                result.append(i + 1 + ". parameter: " + this.m_Parameters[i] + "\n");
            }
            result.append("Evaluation: " + this.getEvaluation().getSelectedTag().getReadable() + "\nCoordinates: " + this.getBestCoordinates() + "\n");
            result.append("Values: " + this.getBestValues() + "\n\n" + this.m_Classifier.toString());
            if (this.m_Debug) {
                result.append("\n\nTrace (format: #. folds/performance - setup):\n");
                for (i = 0; i < this.getTraceSize(); ++i) {
                    result.append("\n" + (i + 1) + ". " + this.getTraceFolds(i) + "/" + this.getTraceValue(i) + " - " + this.getTraceClassifierAsCli(i));
                }
            }
        }
        return result.toString();
    }

    public String toSummaryString() {
        String result = "Best classifier: " + this.getCommandline(this.getBestClassifier());
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 4521 $");
    }

    public static void main(String[] args) {
        MultiSearch.runClassifier((Classifier)new MultiSearch(), (String[])args);
    }
}

