/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.meta.multisearch.MultiSearchCapable;
import weka.classifiers.meta.multisearch.Performance;
import weka.classifiers.meta.multisearch.PerformanceCache;
import weka.classifiers.meta.multisearch.TraceableOptimizer;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.Space;

public abstract class AbstractSearch
implements Serializable,
Cloneable,
OptionHandler,
TraceableOptimizer {
    private static final long serialVersionUID = -8938470419284825738L;
    protected List<Map.Entry<Integer, Performance>> m_Trace;
    protected transient MultiSearchCapable m_Owner;
    protected boolean m_Debug;
    protected Space m_Space;
    protected int m_NumSetups;
    protected Vector<Performance> m_Performances;
    protected PerformanceCache m_Cache;
    protected boolean m_UniformPerformance = false;
    protected Point<Object> m_Values = null;

    public abstract String globalInfo();

    public void setOwner(MultiSearchCapable value) {
        this.m_Owner = value;
    }

    public List<String> getSearchDimensions() {
        ArrayList<String> dimensions = new ArrayList<String>();
        for (int i = 0; i < this.m_Space.dimensions(); ++i) {
            dimensions.add(this.m_Space.getDimension(i).getLabel());
        }
        return dimensions;
    }

    public MultiSearchCapable retrieveOwner() {
        return this.m_Owner;
    }

    public Object clone() {
        AbstractSearch result;
        try {
            result = (AbstractSearch)this.getClass().newInstance();
            result.setOptions(this.getOptions());
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
        }
        return result;
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tWhether to enable debugging output.\n\t(default off)", "D", 0, "-D"));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.getDebug()) {
            result.add("-D");
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        this.setDebug(Utils.getFlag((String)"D", (String[])options));
        Utils.checkForRemainingOptions((String[])options);
    }

    public void setDebug(boolean debug) {
        this.m_Debug = debug;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "If set to true, search may output additional info to the console.";
    }

    public void log(String message) {
        this.m_Owner.log(message);
    }

    public void log(String message, boolean onlyLog) {
        this.m_Owner.log(message, onlyLog);
    }

    protected String logPerformances(Space space, Vector<Performance> performances, Tag type) {
        return this.m_Owner.logPerformances(space, performances, type);
    }

    protected void logPerformances(Space space, Vector<Performance> performances) {
        this.m_Owner.logPerformances(space, performances);
    }

    public void addPerformance(Performance performance, int folds) {
        this.m_Performances.add(performance);
        this.m_Cache.add(folds, performance);
        this.m_Trace.add(new AbstractMap.SimpleEntry<Integer, Performance>(folds, performance));
    }

    public Point<Object> getValues() {
        return this.m_Values;
    }

    @Override
    public int getTraceSize() {
        return this.m_Trace.size();
    }

    @Override
    public String getTraceClassifierAsCli(int index) {
        return this.getCommandline(this.m_Trace.get(index).getValue().getClassifier());
    }

    @Override
    public Double getTraceValue(int index) {
        return this.m_Trace.get(index).getValue().getPerformance();
    }

    @Override
    public Integer getTraceFolds(int index) {
        return this.m_Trace.get(index).getKey();
    }

    @Override
    public List<Map.Entry<String, Object>> getTraceParameterSettings(int index) {
        Vector<Map.Entry<String, Object>> result = new Vector<Map.Entry<String, Object>>();
        List<String> dimensions = this.getSearchDimensions();
        for (int i = 0; i < dimensions.size(); ++i) {
            String parameter = dimensions.get(i);
            Object value = this.m_Trace.get(index).getValue().getValues().getValue(i);
            AbstractMap.SimpleEntry<String, Object> current = new AbstractMap.SimpleEntry<String, Object>(parameter, value);
            result.add(i, current);
        }
        return result;
    }

    @Override
    public List<Map.Entry<Integer, Performance>> getTrace() {
        return this.m_Trace;
    }

    public String getCommandline(Object obj) {
        return this.m_Owner.getCommandline(obj);
    }

    protected void check(Instances data) throws Exception {
        if (this.m_Owner == null) {
            throw new IllegalStateException("No owner set!");
        }
        if (data == null) {
            throw new IllegalStateException("No data provided!");
        }
    }

    public void preSearch(Instances data) throws Exception {
        this.m_Cache = new PerformanceCache();
        this.m_Performances = new Vector();
        this.m_Trace = new Vector<Map.Entry<Integer, Performance>>();
        this.m_Owner.getGenerator().reset();
        this.m_Space = this.m_Owner.getGenerator().getSpace();
    }

    public abstract SearchResult doSearch(Instances var1) throws Exception;

    public SearchResult postSearch(Instances data, SearchResult best) throws Exception {
        return best;
    }

    public SearchResult search(Instances data) throws Exception {
        SearchResult result;
        try {
            this.log("\n" + this.getClass().getName() + "\n" + this.getClass().getName().replaceAll(".", "=") + "\nOptions: " + Utils.joinOptions((String[])this.getOptions()) + "\n");
            this.log("\n---> check");
            this.check(data);
            this.log("\n---> preSearch");
            this.preSearch(data);
            this.log("\n---> doSearch");
            SearchResult best = this.doSearch(data);
            this.log("\n---> postSearch");
            result = this.postSearch(data, best);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.cleanUpSearch();
        }
        return result;
    }

    public void cleanUpSearch() {
    }

    public static class SearchResult
    implements Serializable {
        private static final long serialVersionUID = -5322332623001051928L;
        public Classifier classifier = null;
        public Performance performance = null;
        public Point<Object> values = null;
    }
}

