/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.Future;
import weka.classifiers.Classifier;
import weka.classifiers.meta.multisearch.AbstractMultiThreadedSearch;
import weka.classifiers.meta.multisearch.AbstractSearch;
import weka.classifiers.meta.multisearch.Performance;
import weka.classifiers.meta.multisearch.PerformanceComparator;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.core.setupgenerator.Point;
import weka.core.setupgenerator.Space;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;

public class DefaultSearch
extends AbstractMultiThreadedSearch {
    private static final long serialVersionUID = -3579744329581176799L;
    protected double m_SampleSize = 100.0;
    protected int m_InitialSpaceNumFolds = 2;
    protected int m_SubsequentSpaceNumFolds = 10;
    protected File m_InitialSpaceTestSet = new File(".");
    protected File m_SubsequentSpaceTestSet = new File(".");
    protected Instances m_InitialSpaceTestInst;
    protected Instances m_SubsequentSpaceTestInst;
    protected boolean m_Lenient = false;

    @Override
    public String globalInfo() {
        return "Performs a search of an arbitrary number of parameters of a classifier and chooses the best setup found for the actual training.\nThe properties being explored are totally up to the user.\n\nE.g., if you have a FilteredClassifier selected as base classifier, sporting a PLSFilter and you want to explore the number of PLS components, then your property will be made up of the following components:\n - filter: referring to the FilteredClassifier's property (= PLSFilter)\n - numComponents: the actual property of the PLSFilter that we want to modify\nAnd assembled, the property looks like this:\n  filter.numComponents\n\nThe initial space is worked on with 2-fold CV to determine the values of the parameters for the selected type of evaluation (e.g., accuracy). The best point in the space is then taken as center and a 10-fold CV is performed with the adjacent parameters. If better parameters are found, then this will act as new center and another 10-fold CV will be performed (kind of hill-climbing). This process is repeated until no better pair is found or the best pair is on the border of the parameter space.\nThe number of CV-folds for the initial and subsequent spaces can be adjusted, of course.\n\nInstead of using cross-validation, it is possible to specify test sets, for the initial space evaluation and the subsequent ones.\n\nThe outcome of a mathematical function (= double), MultiSearch will convert to integers (values are just cast to int), booleans (0 is false, otherwise true), float, char and long if necessary.\nVia a user-supplied 'list' of parameters (blank-separated), one can also set strings and selected tags (drop-down comboboxes in Weka's GenericObjectEditor). Classnames with options (e.g., classifiers with their options) are possible as well.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe size (in percent) of the sample to search the inital space with.\n\t(default: 100)", "sample-size", 1, "-sample-size <num>"));
        result.addElement(new Option("\tThe number of cross-validation folds for the initial space.\n\tNumbers smaller than 2 turn off cross-validation and just\n\tperform evaluation on the training set.\n\t(default: 2)", "initial-folds", 1, "-initial-folds <num>"));
        result.addElement(new Option("\tThe number of cross-validation folds for the subsequent sub-spaces.\n\tNumbers smaller than 2 turn off cross-validation and just\n\tperform evaluation on the training set.\n\t(default: 10)", "subsequent-folds", 1, "-subsequent-folds <num>"));
        result.addElement(new Option("\tThe (optional) test set to use for the initial space.\n\tGets ignored if pointing to a file. Overrides cross-validation.\n\t(default: .)", "initial-test-set", 1, "-initial-test-set <filename>"));
        result.addElement(new Option("\tThe (optional) test set to use for the subsequent sub-spaces.\n\tGets ignored if pointing to a file. Overrides cross-validation.\n\t(default: .)", "subsequent-test-set", 1, "-subsequent-test-set <filename>"));
        result.addElement(new Option("\tWhether to be more lenient, eg to accept that all results have been cached.\n\t(default: off)", "lenient", 0, "-lenient"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        return result.elements();
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-sample-size");
        result.add("" + this.getSampleSizePercent());
        result.add("-initial-folds");
        result.add("" + this.getInitialSpaceNumFolds());
        result.add("-subsequent-folds");
        result.add("" + this.getSubsequentSpaceNumFolds());
        result.add("-initial-test-set");
        result.add("" + this.getInitialSpaceTestSet());
        result.add("-subsequent-test-set");
        result.add("" + this.getSubsequentSpaceTestSet());
        if (this.getLenient()) {
            result.add("-lenient");
        }
        String[] options = super.getOptions();
        for (int i = 0; i < options.length; ++i) {
            result.add(options[i]);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"sample-size", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        tmpStr = Utils.getOption((String)"initial-folds", (String[])options);
        if (tmpStr.length() != 0) {
            this.setInitialSpaceNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setInitialSpaceNumFolds(2);
        }
        tmpStr = Utils.getOption((String)"subsequent-folds", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSubsequentSpaceNumFolds(Integer.parseInt(tmpStr));
        } else {
            this.setSubsequentSpaceNumFolds(10);
        }
        tmpStr = Utils.getOption((String)"initial-test-set", (String[])options);
        if (tmpStr.length() != 0) {
            this.setInitialSpaceTestSet(new File(tmpStr));
        } else {
            this.setInitialSpaceTestSet(new File(System.getProperty("user.dir")));
        }
        tmpStr = Utils.getOption((String)"subsequent-test-set", (String[])options);
        if (tmpStr.length() != 0) {
            this.setSubsequentSpaceTestSet(new File(tmpStr));
        } else {
            this.setSubsequentSpaceTestSet(new File(System.getProperty("user.dir")));
        }
        this.setLenient(Utils.getFlag((String)"lenient", (String[])options));
        super.setOptions(options);
    }

    public String sampleSizePercentTipText() {
        return "The sample size (in percent) to use in the initial space search.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSize;
    }

    public void setSampleSizePercent(double value) {
        this.m_SampleSize = value;
    }

    public String initialSpaceNumFoldsTipText() {
        return "The number of cross-validation folds when evaluating the initial space; values smaller than 2 turn cross-validation off and simple evaluation on the training set is performed.";
    }

    public int getInitialSpaceNumFolds() {
        return this.m_InitialSpaceNumFolds;
    }

    public void setInitialSpaceNumFolds(int value) {
        this.m_InitialSpaceNumFolds = value;
    }

    public String subsequentSpaceNumFoldsTipText() {
        return "The number of cross-validation folds when evaluating the subsequent sub-spaces; values smaller than 2 turn cross-validation off and simple evaluation on the training set is performed.";
    }

    public int getSubsequentSpaceNumFolds() {
        return this.m_SubsequentSpaceNumFolds;
    }

    public void setSubsequentSpaceNumFolds(int value) {
        this.m_SubsequentSpaceNumFolds = value;
    }

    public String initialSpaceTestSetTipText() {
        return "The (optional) test set to use for evaluating the initial search space; overrides cross-validation; gets ignored if pointing to a directory.";
    }

    public File getInitialSpaceTestSet() {
        return this.m_InitialSpaceTestSet;
    }

    public void setInitialSpaceTestSet(File value) {
        this.m_InitialSpaceTestSet = value;
    }

    public String subsequentSpaceTestSetTipText() {
        return "The (optional) test set to use for evaluating the subsequent search sub-spaces; overrides cross-validation; gets ignored if pointing to a directory.";
    }

    public File getSubsequentSpaceTestSet() {
        return this.m_SubsequentSpaceTestSet;
    }

    public void setSubsequentSpaceTestSet(File value) {
        this.m_SubsequentSpaceTestSet = value;
    }

    public String lenientTipText() {
        return "If enable, the search is more lenient (eg does not throw an exception when all results have been cached).";
    }

    public boolean getLenient() {
        return this.m_Lenient;
    }

    public void setLenient(boolean value) {
        this.m_Lenient = value;
    }

    protected Performance determineBestInSpace(Space space, Instances train, Instances test, int folds, boolean postClean) throws Exception {
        int i;
        this.m_Performances.clear();
        if (test != null) {
            this.log("Determining best values using test set in space:\n" + space + "\n");
        } else if (folds >= 2) {
            this.log("Determining best values with " + folds + "-fold CV in space:\n" + space + "\n");
        } else {
            this.log("Determining best values with evaluation on training set in space:\n" + space + "\n");
        }
        Enumeration<Point<Object>> enm = space.values();
        boolean allCached = true;
        this.m_NumSetups = space.size();
        int classLabel = train.classAttribute().isNominal() ? this.m_Owner.getClassLabelIndex(train.classAttribute().numValues()) : -1;
        ArrayList tasks = new ArrayList();
        ArrayList results = new ArrayList();
        while (enm.hasMoreElements()) {
            Point<Object> values = enm.nextElement();
            if (this.m_Cache.isCached(folds, values)) {
                Performance performance = this.m_Cache.get(folds, values);
                this.m_Performances.add(performance);
                this.m_Trace.add(new AbstractMap.SimpleEntry<Integer, Performance>(folds, performance));
                this.log(performance + ": cached=true");
                continue;
            }
            allCached = false;
            Object newTask = this.m_Owner.getFactory().newTask(this.m_Owner, train, test, this.m_Owner.getGenerator(), values, folds, this.m_Owner.getEvaluation().getSelectedTag().getID(), classLabel);
            tasks.add(newTask);
            results.add(this.m_ExecutorPool.submit(newTask));
        }
        try {
            for (i = 0; i < results.size(); ++i) {
                if (((Boolean)((Future)results.get(i)).get()).booleanValue()) continue;
                System.err.println("Execution of evaluation thread failed:\n" + tasks.get(i));
                throw new IllegalStateException("Execution of evaluation thread failed:\n" + tasks.get(i));
            }
        }
        catch (Exception e) {
            System.err.println("Thread-based execution of evaluation tasks failed!");
            e.printStackTrace();
            throw new IllegalStateException("Thread-based execution of evaluation tasks failed!", e);
        }
        if (allCached) {
            if (!this.m_Lenient) {
                this.log("All points were already cached - abnormal state!");
                throw new IllegalStateException("All points were already cached - abnormal state!");
            }
            this.log("All points were already cached!");
        }
        Collections.sort(this.m_Performances, new PerformanceComparator(this.m_Owner.getEvaluation().getSelectedTag().getID(), this.m_Owner.getMetrics()));
        Performance result = (Performance)this.m_Performances.firstElement();
        this.m_UniformPerformance = true;
        Performance p1 = (Performance)this.m_Performances.get(0);
        for (i = 1; i < this.m_Performances.size(); ++i) {
            Performance p2 = (Performance)this.m_Performances.get(i);
            if (p2.getPerformance(this.m_Owner.getEvaluation().getSelectedTag().getID()) == p1.getPerformance(this.m_Owner.getEvaluation().getSelectedTag().getID())) continue;
            this.m_UniformPerformance = false;
            break;
        }
        if (this.m_UniformPerformance) {
            this.log("All performances are the same!");
        }
        this.logPerformances(space, this.m_Performances);
        this.log("\nBest performance:\n" + this.m_Performances.firstElement());
        if (postClean) {
            this.m_Performances.clear();
        }
        return result;
    }

    public Vector<Performance> getPerformances() {
        return this.m_Performances;
    }

    protected Performance findBest(Instances inst) throws Exception {
        Instances sample;
        this.log("Step 1:\n");
        if (this.getSampleSizePercent() == 100.0) {
            sample = inst;
        } else {
            this.log("Generating sample (" + this.getSampleSizePercent() + "%)");
            Resample resample = new Resample();
            resample.setRandomSeed(this.retrieveOwner().getSeed());
            resample.setSampleSizePercent(this.getSampleSizePercent());
            resample.setInputFormat(inst);
            sample = Filter.useFilter((Instances)inst, (Filter)resample);
        }
        int iteration = 0;
        this.m_UniformPerformance = false;
        this.log("\n=== Initial space - Start ===");
        Performance result = this.determineBestInSpace(this.m_Space, sample, this.m_InitialSpaceTestInst, this.m_InitialSpaceNumFolds, true);
        this.log("\nResult of Step 1: " + result + "\n");
        this.log("=== Initial space - End ===\n");
        boolean finished = this.m_UniformPerformance;
        if (!finished) {
            do {
                ++iteration;
                Performance resultOld = (Performance)result.clone();
                Point<Integer> center = this.m_Space.getLocations(result.getValues());
                if (this.m_Space.isOnBorder(center)) {
                    this.log("Center is on border of space.");
                    finished = true;
                }
                if (finished) continue;
                Space neighborSpace = this.m_Space.subspace(center);
                result = this.determineBestInSpace(neighborSpace, sample, this.m_SubsequentSpaceTestInst, this.m_SubsequentSpaceNumFolds, true);
                this.log("\nResult of Step 2/Iteration " + iteration + ":\n" + result);
                finished = this.m_UniformPerformance;
                if (!result.getValues().equals(resultOld.getValues())) continue;
                finished = true;
                this.log("\nNo better point found.");
            } while (!finished);
        }
        this.log("\nFinal result: " + result);
        Point<Object> evals = this.m_Owner.getGenerator().evaluate(result.getValues());
        Classifier cls = (Classifier)this.m_Owner.getGenerator().setup((Serializable)this.m_Owner.getClassifier(), evals);
        this.log("Classifier: " + this.getCommandline(cls));
        return result;
    }

    protected void loadTestData(Instances data) throws Exception {
        String msg;
        this.m_InitialSpaceTestInst = null;
        if (this.m_InitialSpaceTestSet.exists() && !this.m_InitialSpaceTestSet.isDirectory()) {
            this.m_InitialSpaceTestInst = ConverterUtils.DataSource.read((String)this.m_InitialSpaceTestSet.getAbsolutePath());
            this.m_InitialSpaceTestInst.setClassIndex(data.classIndex());
            msg = data.equalHeadersMsg(this.m_InitialSpaceTestInst);
            if (msg != null) {
                throw new IllegalArgumentException("Test set for initial space not compatible with training dta:\n" + msg);
            }
            this.m_InitialSpaceTestInst.deleteWithMissingClass();
            this.log("Using test set for initial space: " + this.m_InitialSpaceTestSet);
        }
        this.m_SubsequentSpaceTestInst = null;
        if (this.m_SubsequentSpaceTestSet.exists() && !this.m_SubsequentSpaceTestSet.isDirectory()) {
            this.m_SubsequentSpaceTestInst = ConverterUtils.DataSource.read((String)this.m_SubsequentSpaceTestSet.getAbsolutePath());
            this.m_SubsequentSpaceTestInst.setClassIndex(data.classIndex());
            msg = data.equalHeadersMsg(this.m_SubsequentSpaceTestInst);
            if (msg != null) {
                throw new IllegalArgumentException("Test set for subsequent sub-spaces not compatible with training dta:\n" + msg);
            }
            this.m_SubsequentSpaceTestInst.deleteWithMissingClass();
            this.log("Using test set for subsequent sub-spaces: " + this.m_InitialSpaceTestSet);
        }
    }

    @Override
    public AbstractSearch.SearchResult doSearch(Instances data) throws Exception {
        this.loadTestData(data);
        Performance performance = this.findBest(new Instances(data));
        Point<Object> evals = this.m_Owner.getGenerator().evaluate(performance.getValues());
        AbstractSearch.SearchResult result = new AbstractSearch.SearchResult();
        result.classifier = (Classifier)this.m_Owner.getGenerator().setup((Serializable)this.m_Owner.getClassifier(), evals);
        result.performance = performance;
        result.values = evals;
        return result;
    }
}

