/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.multisearch;

import java.io.Serializable;
import java.util.Comparator;
import weka.classifiers.meta.multisearch.AbstractEvaluationMetrics;
import weka.classifiers.meta.multisearch.Performance;

public class PerformanceComparator
implements Comparator<Performance>,
Serializable {
    private static final long serialVersionUID = 6507592831825393847L;
    protected int m_Evaluation;
    protected AbstractEvaluationMetrics m_Metrics;

    public PerformanceComparator(int evaluation, AbstractEvaluationMetrics metrics) {
        this.m_Evaluation = evaluation;
        this.m_Metrics = metrics;
    }

    public int getEvaluation() {
        return this.m_Evaluation;
    }

    public AbstractEvaluationMetrics getMetrics() {
        return this.m_Metrics;
    }

    @Override
    public int compare(Performance o1, Performance o2) {
        double p2;
        if (o1.getEvaluation() != o2.getEvaluation()) {
            throw new IllegalArgumentException("Comparing different types of performances!");
        }
        double p1 = o1.getPerformance();
        int result = p1 < (p2 = o2.getPerformance()) ? -1 : (p1 > p2 ? 1 : o1.getValues().compareTo(o2.getValues()));
        if (this.getMetrics().invert(this.getEvaluation())) {
            result = -result;
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PerformanceComparator)) {
            throw new IllegalArgumentException("Must be PerformanceComparator!");
        }
        return this.m_Evaluation == ((PerformanceComparator)obj).m_Evaluation;
    }
}

