/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import weka.core.Utils;
import weka.core.setupgenerator.SpaceDimension;

public class FunctionSpaceDimension
extends SpaceDimension {
    private static final long serialVersionUID = -7709016830854739486L;

    public FunctionSpaceDimension(double min, double max, double step, String label) {
        this.m_Min = min;
        this.m_Max = max;
        this.m_Step = step;
        this.m_Label = label;
        this.m_Width = (int)StrictMath.round((this.m_Max - this.m_Min) / this.m_Step) + 1;
        if (this.m_Min >= this.m_Max) {
            throw new IllegalArgumentException("Min must be smaller than Max!");
        }
        if (this.m_Step <= 0.0) {
            throw new IllegalArgumentException("Step must be a positive number!");
        }
        if (!Utils.eq((double)(this.m_Min + (double)(this.m_Width - 1) * this.m_Step), (double)this.m_Max)) {
            throw new IllegalArgumentException("Axis doesn't match! Provided max: " + this.m_Max + ", calculated max via min and step size: " + (this.m_Min + (double)(this.m_Width - 1) * this.m_Step));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof FunctionSpaceDimension)) {
            return false;
        }
        FunctionSpaceDimension dim = (FunctionSpaceDimension)o;
        if (this.width() != dim.width()) {
            return false;
        }
        if (this.getMin() != dim.getMin()) {
            return false;
        }
        if (this.getStep() != dim.getStep()) {
            return false;
        }
        return this.getLabel().equals(dim.getLabel());
    }

    @Override
    public Object getValue(int x) {
        if (x >= this.width()) {
            throw new IllegalArgumentException("Index out of scope on axis (" + x + " >= " + this.width() + ")!");
        }
        return this.m_Min + this.m_Step * (double)x;
    }

    @Override
    public int getLocation(Object value) {
        int result = 0;
        double distance = this.m_Step;
        for (int i = 0; i < this.width(); ++i) {
            double currDistance = StrictMath.abs((Double)value - (Double)this.getValue(i));
            if (!Utils.sm((double)currDistance, (double)distance)) continue;
            distance = currDistance;
            result = i;
        }
        return result;
    }

    @Override
    public FunctionSpaceDimension subdimension(int left, int right) {
        return new FunctionSpaceDimension((Double)this.getValue(left), (Double)this.getValue(right), this.getStep(), this.getLabel());
    }

    @Override
    public String toString() {
        return "dimension: " + this.getLabel() + ", min: " + this.getMin() + ", max: " + this.getMax() + ", step: " + this.getStep();
    }
}

