/*
 * Decompiled with CFR 0.152.
 */
package weka.core.setupgenerator;

import weka.core.Utils;
import weka.core.setupgenerator.SpaceDimension;

public class ListSpaceDimension
extends SpaceDimension {
    private static final long serialVersionUID = -7709016830854739486L;
    protected String[] m_List;

    public ListSpaceDimension(int min, int max, String[] list, String label) {
        this.m_Min = min;
        this.m_Max = max;
        this.m_Step = -1.0;
        this.m_Label = label;
        this.m_Width = max - min + 1;
        this.m_List = (String[])list.clone();
        if (this.m_Min >= (double)this.m_List.length) {
            throw new IllegalArgumentException("Min must be smaller than list length (min=" + min + ", list=" + list.length + ")!");
        }
        if (this.m_Max >= (double)this.m_List.length) {
            throw new IllegalArgumentException("Max must be smaller than list length (max=" + max + ", list=" + list.length + ")!");
        }
        if (this.m_Min > this.m_Max) {
            throw new IllegalArgumentException("Min must be at most Max (min=" + min + ", max=" + max + ")!");
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ListSpaceDimension)) {
            return false;
        }
        ListSpaceDimension dim = (ListSpaceDimension)o;
        if (this.getList().length != dim.getList().length) {
            return false;
        }
        for (int i = 0; i < this.getList().length; ++i) {
            if (this.getList()[i].equals(dim.getList()[i])) continue;
            return false;
        }
        return true;
    }

    public String[] getList() {
        return this.m_List;
    }

    @Override
    public Object getValue(int x) {
        if (x >= this.width()) {
            throw new IllegalArgumentException("Index out of scope on axis (" + x + " >= " + this.width() + ")!");
        }
        return this.m_List[(int)this.m_Min + x];
    }

    @Override
    public int getLocation(Object value) {
        int result = 0;
        String valueStr = value.toString();
        for (int i = 0; i < this.width(); ++i) {
            if (!this.getValue(i).equals(valueStr)) continue;
            result = (int)this.m_Min + i;
            break;
        }
        return result;
    }

    @Override
    public ListSpaceDimension subdimension(int left, int right) {
        return new ListSpaceDimension(left, right, this.getList(), this.getLabel());
    }

    @Override
    public String toString() {
        return "dimension: " + this.getLabel() + ", min: " + this.getMin() + ", max: " + this.getMax() + ", list: " + Utils.arrayToString((Object)this.getList());
    }
}

