/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.fingerprint;

import com.musicg.fingerprint.FingerprintManager;
import com.musicg.fingerprint.FingerprintSimilarity;
import com.musicg.fingerprint.PairManager;
import com.musicg.math.rank.MapRankInteger;
import java.util.HashMap;
import java.util.List;

public class FingerprintSimilarityComputer {
    private FingerprintSimilarity fingerprintSimilarity;
    byte[] fingerprint1;
    byte[] fingerprint2;

    public FingerprintSimilarityComputer(byte[] fingerprint1, byte[] fingerprint2) {
        this.fingerprint1 = fingerprint1;
        this.fingerprint2 = fingerprint2;
        this.fingerprintSimilarity = new FingerprintSimilarity();
    }

    public FingerprintSimilarity getFingerprintsSimilarity() {
        float similarity;
        HashMap<Integer, Integer> offset_Score_Table = new HashMap<Integer, Integer>();
        int numFrames = 0;
        float score = 0.0f;
        int mostSimilarFramePosition = Integer.MIN_VALUE;
        numFrames = this.fingerprint1.length > this.fingerprint2.length ? FingerprintManager.getNumFrames(this.fingerprint2) : FingerprintManager.getNumFrames(this.fingerprint1);
        PairManager pairManager = new PairManager();
        HashMap<Integer, List<Integer>> this_Pair_PositionList_Table = pairManager.getPair_PositionList_Table(this.fingerprint1);
        HashMap<Integer, List<Integer>> compareWave_Pair_PositionList_Table = pairManager.getPair_PositionList_Table(this.fingerprint2);
        for (int compareWaveHashNumber : compareWave_Pair_PositionList_Table.keySet()) {
            if (!this_Pair_PositionList_Table.containsKey(compareWaveHashNumber) || !compareWave_Pair_PositionList_Table.containsKey(compareWaveHashNumber)) continue;
            List<Integer> wavePositionList = this_Pair_PositionList_Table.get(compareWaveHashNumber);
            List<Integer> compareWavePositionList = compareWave_Pair_PositionList_Table.get(compareWaveHashNumber);
            for (int thisPosition : wavePositionList) {
                for (int compareWavePosition : compareWavePositionList) {
                    int offset = thisPosition - compareWavePosition;
                    if (offset_Score_Table.containsKey(offset)) {
                        offset_Score_Table.put(offset, (Integer)offset_Score_Table.get(offset) + 1);
                        continue;
                    }
                    offset_Score_Table.put(offset, 1);
                }
            }
        }
        MapRankInteger mapRank = new MapRankInteger(offset_Score_Table, false);
        List orderedKeyList = mapRank.getOrderedKeyList(100, true);
        if (orderedKeyList.size() > 0) {
            int key = (Integer)orderedKeyList.get(0);
            if (mostSimilarFramePosition == Integer.MIN_VALUE) {
                mostSimilarFramePosition = key;
                score = ((Integer)offset_Score_Table.get(key)).intValue();
                if (offset_Score_Table.containsKey(key - 1)) {
                    score += (float)((Integer)offset_Score_Table.get(key - 1) / 2);
                }
                if (offset_Score_Table.containsKey(key + 1)) {
                    score += (float)((Integer)offset_Score_Table.get(key + 1) / 2);
                }
            }
        }
        if ((similarity = (score /= (float)numFrames)) > 1.0f) {
            similarity = 1.0f;
        }
        this.fingerprintSimilarity.setMostSimilarFramePosition(mostSimilarFramePosition);
        this.fingerprintSimilarity.setScore(score);
        this.fingerprintSimilarity.setSimilarity(similarity);
        return this.fingerprintSimilarity;
    }
}

