/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.graphic;

import com.musicg.wave.Wave;
import com.musicg.wave.extension.Spectrogram;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class GraphicRender {
    public static final float WAVEFORM_DEFAULT_TIMESTEP = 0.1f;
    private int xMarker = -1;
    private int yMarker = -1;

    public void renderWaveform(Wave wave, String filename) {
        this.renderWaveform(wave, 0.1f, filename);
    }

    public void renderWaveform(Wave wave, float timeStep, String filename) {
        double middleLine = 0.0;
        if (wave.getWaveHeader().getBitsPerSample() == 8) {
            middleLine = 0.5;
        }
        double[] nAmplitudes = wave.getNormalizedAmplitudes();
        int width = (int)((float)(nAmplitudes.length / wave.getWaveHeader().getSampleRate()) / timeStep);
        int height = 500;
        int middle = height / 2;
        int magnifier = 1000;
        int numSamples = nAmplitudes.length;
        if (width > 0) {
            int numSamplePerTimeFrame = numSamples / width;
            int[] scaledPosAmplitudes = new int[width];
            int[] scaledNegAmplitudes = new int[width];
            for (int i = 0; i < width; ++i) {
                double sumPosAmplitude = 0.0;
                double sumNegAmplitude = 0.0;
                int startSample = i * numSamplePerTimeFrame;
                for (int j = 0; j < numSamplePerTimeFrame; ++j) {
                    double a = nAmplitudes[startSample + j];
                    if (a > middleLine) {
                        sumPosAmplitude += a - middleLine;
                        continue;
                    }
                    sumNegAmplitude += a - middleLine;
                }
                int scaledPosAmplitude = (int)(sumPosAmplitude / (double)numSamplePerTimeFrame * (double)magnifier + (double)middle);
                int scaledNegAmplitude = (int)(sumNegAmplitude / (double)numSamplePerTimeFrame * (double)magnifier + (double)middle);
                scaledPosAmplitudes[i] = scaledPosAmplitude;
                scaledNegAmplitudes[i] = scaledNegAmplitude;
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            Graphics2D graphics = bufferedImage.createGraphics();
            graphics.setPaint(new Color(255, 255, 255));
            graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            for (int i = 0; i < width; ++i) {
                for (int j = scaledNegAmplitudes[i]; j < scaledPosAmplitudes[i]; ++j) {
                    int y = height - j;
                    if (y < 0) {
                        y = 0;
                    } else if (y >= height) {
                        y = height - 1;
                    }
                    bufferedImage.setRGB(i, y, 0);
                }
            }
            try {
                int dotPos = filename.lastIndexOf(".");
                String extension = filename.substring(dotPos + 1);
                ImageIO.write((RenderedImage)bufferedImage, extension, new File(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("renderWaveform error: Empty Wave");
        }
    }

    public void renderSpectrogram(Spectrogram spectrogram, String filename) {
        this.renderSpectrogramData(spectrogram.getNormalizedSpectrogramData(), filename);
    }

    public void renderSpectrogramData(double[][] spectrogramData, String filename) {
        if (spectrogramData != null) {
            int width = spectrogramData.length;
            int height = spectrogramData[0].length;
            BufferedImage bufferedImage = new BufferedImage(width, height, 1);
            for (int i = 0; i < width; ++i) {
                int j;
                if (i == this.xMarker) {
                    for (j = 0; j < height; ++j) {
                        bufferedImage.setRGB(i, j, 65280);
                    }
                    continue;
                }
                for (j = 0; j < height; ++j) {
                    int value = j == this.yMarker ? 0xFF0000 : 255 - (int)(spectrogramData[i][j] * 255.0);
                    bufferedImage.setRGB(i, height - 1 - j, value << 16 | value << 8 | value);
                }
            }
            try {
                int dotPos = filename.lastIndexOf(".");
                String extension = filename.substring(dotPos + 1);
                ImageIO.write((RenderedImage)bufferedImage, extension, new File(filename));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("renderSpectrogramData error: Empty Wave");
        }
    }

    public void setVerticalMarker(int x) {
        this.xMarker = x;
    }

    public void setHorizontalMarker(int y) {
        this.yMarker = y;
    }

    public void resetMarkers() {
        this.xMarker = -1;
        this.yMarker = -1;
    }
}

