/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.pitch;

import java.util.Arrays;

public class PitchHandler {
    public double getToneChanged(double f1, double f2) {
        return Math.log(f1 / f2) / Math.log(2.0) * 12.0;
    }

    public double getHarmonicProbability(double[] frequencies) {
        int harmonicCount = 0;
        int count = 0;
        Arrays.sort(frequencies);
        for (int i = 0; i < frequencies.length; ++i) {
            for (int j = i + 1; j < frequencies.length; ++j) {
                if (this.isHarmonic(frequencies[i], frequencies[j])) {
                    ++harmonicCount;
                }
                ++count;
            }
        }
        return (double)harmonicCount / (double)count;
    }

    public boolean isHarmonic(double f1, double f2) {
        if (Math.abs(this.getToneChanged(f1, f2)) >= 1.0) {
            double minF0 = 100.0;
            int minDivisor = (int)(f1 / minF0);
            for (int i = 1; i <= minDivisor; ++i) {
                double f0 = f1 / (double)i;
                int maxMultiplier = (int)(f2 / f0 + 1.0);
                for (int j = 2; j <= maxMultiplier; ++j) {
                    double f = f0 * (double)j;
                    double diff = Math.abs(this.getToneChanged(f, f2) % 12.0);
                    if (diff > 6.0) {
                        diff = 12.0 - diff;
                    }
                    if (!(diff <= 1.0)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

