/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.wave.extension;

import com.musicg.dsp.FastFourierTransform;
import com.musicg.dsp.WindowFunction;
import com.musicg.wave.Wave;

public class Spectrogram {
    public static final int SPECTROGRAM_DEFAULT_FFT_SAMPLE_SIZE = 1024;
    public static final int SPECTROGRAM_DEFAULT_OVERLAP_FACTOR = 0;
    private Wave wave;
    private double[][] spectrogram;
    private double[][] absoluteSpectrogram;
    private int fftSampleSize;
    private int overlapFactor;
    private int numFrames;
    private int framesPerSecond;
    private int numFrequencyUnit;
    private double unitFrequency;

    public Spectrogram(Wave wave) {
        this.wave = wave;
        this.fftSampleSize = 1024;
        this.overlapFactor = 0;
        this.buildSpectrogram();
    }

    public Spectrogram(Wave wave, int fftSampleSize, int overlapFactor) {
        this.wave = wave;
        if (Integer.bitCount(fftSampleSize) == 1) {
            this.fftSampleSize = fftSampleSize;
        } else {
            System.err.print("The input number must be a power of 2");
            this.fftSampleSize = 1024;
        }
        this.overlapFactor = overlapFactor;
        this.buildSpectrogram();
    }

    private void buildSpectrogram() {
        int i;
        short[] amplitudes = this.wave.getSampleAmplitudes();
        int numSamples = amplitudes.length;
        int pointer = 0;
        if (this.overlapFactor > 1) {
            int numOverlappedSamples = numSamples * this.overlapFactor;
            int backSamples = this.fftSampleSize * (this.overlapFactor - 1) / this.overlapFactor;
            int fftSampleSize_1 = this.fftSampleSize - 1;
            short[] overlapAmp = new short[numOverlappedSamples];
            pointer = 0;
            for (i = 0; i < amplitudes.length; ++i) {
                overlapAmp[pointer++] = amplitudes[i];
                if (pointer % this.fftSampleSize != fftSampleSize_1) continue;
                i -= backSamples;
            }
            numSamples = numOverlappedSamples;
            amplitudes = overlapAmp;
        }
        this.numFrames = numSamples / this.fftSampleSize;
        this.framesPerSecond = (int)((float)this.numFrames / this.wave.length());
        WindowFunction window = new WindowFunction();
        window.setWindowType("Hamming");
        double[] win = window.generate(this.fftSampleSize);
        double[][] signals = new double[this.numFrames][];
        for (int f = 0; f < this.numFrames; ++f) {
            signals[f] = new double[this.fftSampleSize];
            int startSample = f * this.fftSampleSize;
            for (int n = 0; n < this.fftSampleSize; ++n) {
                signals[f][n] = (double)amplitudes[startSample + n] * win[n];
            }
        }
        this.absoluteSpectrogram = new double[this.numFrames][];
        FastFourierTransform fft = new FastFourierTransform();
        for (i = 0; i < this.numFrames; ++i) {
            this.absoluteSpectrogram[i] = fft.getMagnitudes(signals[i]);
        }
        if (this.absoluteSpectrogram.length > 0) {
            this.numFrequencyUnit = this.absoluteSpectrogram[0].length;
            this.unitFrequency = (double)this.wave.getWaveHeader().getSampleRate() / 2.0 / (double)this.numFrequencyUnit;
            this.spectrogram = new double[this.numFrames][this.numFrequencyUnit];
            double maxAmp = Double.MIN_VALUE;
            double minAmp = Double.MAX_VALUE;
            for (int i2 = 0; i2 < this.numFrames; ++i2) {
                for (int j = 0; j < this.numFrequencyUnit; ++j) {
                    if (this.absoluteSpectrogram[i2][j] > maxAmp) {
                        maxAmp = this.absoluteSpectrogram[i2][j];
                        continue;
                    }
                    if (!(this.absoluteSpectrogram[i2][j] < minAmp)) continue;
                    minAmp = this.absoluteSpectrogram[i2][j];
                }
            }
            double minValidAmp = 1.0E-11f;
            if (minAmp == 0.0) {
                minAmp = minValidAmp;
            }
            double diff = Math.log10(maxAmp / minAmp);
            for (int i3 = 0; i3 < this.numFrames; ++i3) {
                for (int j = 0; j < this.numFrequencyUnit; ++j) {
                    this.spectrogram[i3][j] = this.absoluteSpectrogram[i3][j] < minValidAmp ? 0.0 : Math.log10(this.absoluteSpectrogram[i3][j] / minAmp) / diff;
                }
            }
        }
    }

    public double[][] getNormalizedSpectrogramData() {
        return this.spectrogram;
    }

    public double[][] getAbsoluteSpectrogramData() {
        return this.absoluteSpectrogram;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public int getNumFrequencyUnit() {
        return this.numFrequencyUnit;
    }

    public double getUnitFrequency() {
        return this.unitFrequency;
    }

    public int getFftSampleSize() {
        return this.fftSampleSize;
    }

    public int getOverlapFactor() {
        return this.overlapFactor;
    }
}

