/*
 * Decompiled with CFR 0.152.
 */
package com.musicg.processor;

import com.musicg.processor.IntensityProcessor;
import com.musicg.processor.RobustIntensityProcessor;
import java.util.LinkedList;
import java.util.List;

public class ProcessorChain {
    private double[][] intensities;
    List<IntensityProcessor> processorList = new LinkedList<IntensityProcessor>();

    public ProcessorChain(double[][] intensities) {
        this.intensities = intensities;
        RobustIntensityProcessor robustProcessor = new RobustIntensityProcessor(intensities, 1);
        this.processorList.add(robustProcessor);
        this.process();
    }

    private void process() {
        for (IntensityProcessor processor : this.processorList) {
            processor.execute();
            this.intensities = processor.getIntensities();
        }
    }

    public double[][] getIntensities() {
        return this.intensities;
    }
}

