/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WekaException;

public class MXExpression
extends AbstractClassifier {
    private static final long serialVersionUID = -3849288591385551460L;
    public static final String EXPRESSION = "expression";
    public static final String USE_ATTRIBUTE_NAMES = "use-attribute-names";
    protected String m_Expression = this.getDefaultExpression();
    protected boolean m_UseAttributeNames = this.getDefaultUseAttributeNames();
    protected Map<Integer, String> m_ArgumentNames;

    public String globalInfo() {
        return "Applies the specified expression to make a prediction.\nAll numeric attribute values are accessible via 'attX' (with X being  the 1-based index of the attribute) or their attribute name (lower case, all non-alphanumeric characters removed).\n\nExpression help:\n" + mXparser.getHelp();
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe expression to use.\n\t(default: " + this.getDefaultExpression() + ")", EXPRESSION, 1, "-expression <expression>"));
        result.addElement(new Option("\tIf enabled, attribute names instead of 'attX' are used in the expression.\n\t(default: disabled)", USE_ATTRIBUTE_NAMES, 0, "-use-attribute-names"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public String[] getOptions() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("-expression");
        result.add(this.getExpression());
        if (this.getUseAttributeNames()) {
            result.add("-use-attribute-names");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)EXPRESSION, (String[])options);
        if (!tmpStr.isEmpty()) {
            this.setExpression(tmpStr);
        } else {
            this.setExpression(this.getDefaultExpression());
        }
        this.setUseAttributeNames(Utils.getFlag((String)USE_ATTRIBUTE_NAMES, (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    protected String getDefaultExpression() {
        return "1";
    }

    public void setExpression(String value) {
        this.m_Expression = value;
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to use for making predictions.";
    }

    protected boolean getDefaultUseAttributeNames() {
        return false;
    }

    public void setUseAttributeNames(boolean value) {
        this.m_UseAttributeNames = value;
    }

    public boolean getUseAttributeNames() {
        return this.m_UseAttributeNames;
    }

    public String useAttributeNamesTipText() {
        return "If enabled, attribute names are used instead of 'attX' (lower-case, non-alphanumeric characters stripped).";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities((CapabilitiesHandler)this);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.setMinimumNumberInstances(1);
        return result;
    }

    protected String buildName(Instance inst, int index) {
        if (!this.m_ArgumentNames.containsKey(index)) {
            if (this.getUseAttributeNames()) {
                StringBuilder result = new StringBuilder();
                String name = inst.attribute(index).name().toLowerCase();
                for (int i = 0; i < name.length(); ++i) {
                    char c = name.charAt(i);
                    if (!Character.isLetterOrDigit(c)) continue;
                    result.append(c);
                }
                this.m_ArgumentNames.put(index, result.toString());
            } else {
                this.m_ArgumentNames.put(index, "att" + (index + 1));
            }
        }
        return this.m_ArgumentNames.get(index);
    }

    protected Expression buildExpression(Instance instance) {
        ArrayList<Argument> args = new ArrayList<Argument>();
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (!instance.attribute(i).isNumeric()) continue;
            args.add(new Argument(this.buildName(instance, i) + " = " + instance.value(i), new PrimitiveElement[0]));
        }
        Expression result = new Expression(this.m_Expression, (PrimitiveElement[])args.toArray(new Argument[args.size()]));
        return result;
    }

    public void buildClassifier(Instances data) throws Exception {
        Expression expr;
        this.getCapabilities().testWithFail(data);
        this.m_ArgumentNames = new HashMap<Integer, String>();
        if (data.numInstances() > 0 && !(expr = this.buildExpression(data.instance(0))).checkSyntax()) {
            throw new WekaException("Illegal expression syntax: " + this.m_Expression + "\n" + expr.getErrorMessage());
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        Expression expr = this.buildExpression(instance);
        return expr.calculate();
    }

    public String toString() {
        return "Expression: " + this.m_Expression;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1 $");
    }

    public static void main(String[] args) {
        MXExpression.runClassifier((Classifier)new MXExpression(), (String[])args);
    }
}

