/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SimpleStreamFilter;

public class ChangeCase
extends SimpleStreamFilter {
    private static final long serialVersionUID = 5180866251200474411L;
    protected Range m_AttributeIndices = new Range("first-last");
    protected boolean m_UpperCase;

    public String globalInfo() {
        return "Changes the case to lower case (default) or upper case.";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe attribute range to work on.\nThis is a comma separated list of attribute indices, with \"first\" and \"last\" valid values.\n\tSpecify an inclusive range with \"-\".\n\tE.g: \"first-3,5,6-10,last\".\n\t(default: first-last)", "R", 1, "-R <range>"));
        result.addElement(new Option("\tWhether to convert to upper case.\n\t(default: off)", "uppercase", 0, "-uppercase"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((String)"R", (String[])options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndices(tmpStr);
        } else {
            this.setAttributeIndices("first-last");
        }
        this.setUpperCase(Utils.getFlag((String)"uppercase", (String[])options));
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-R");
        result.add(this.getAttributeIndices());
        if (this.getUpperCase()) {
            result.add("-uppercase");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setAttributeIndices(String value) {
        this.m_AttributeIndices.setRanges(value);
    }

    public String getAttributeIndices() {
        return this.m_AttributeIndices.getRanges();
    }

    public String attributeIndicesTipText() {
        return "Specify range of attributes to act on; this is a comma separated list of attribute indices, with \"first\" and \"last\" valid values; specify an inclusive range with \"-\"; eg: \"first-3,5,6-10,last\".";
    }

    public void setUpperCase(boolean value) {
        this.m_UpperCase = value;
    }

    public boolean getUpperCase() {
        return this.m_UpperCase;
    }

    public String upperCaseTipText() {
        return "If set to true, the strings get converted to upper case instead of lower case.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected Instances determineOutputFormat(Instances inputFormat) throws Exception {
        this.m_AttributeIndices.setUpper(inputFormat.numAttributes() - 1);
        return new Instances(inputFormat, 0);
    }

    protected Instance process(Instance instance) throws Exception {
        double[] values = new double[instance.numAttributes()];
        double[] current = instance.toDoubleArray();
        for (int i = 0; i < instance.numAttributes() - 1; ++i) {
            if (!instance.attribute(i).isString() || !this.m_AttributeIndices.isInRange(i)) {
                values[i] = current[i];
                continue;
            }
            if (instance.isMissing(i)) {
                values[i] = Utils.missingValue();
                continue;
            }
            String newString = this.m_UpperCase ? instance.stringValue(i).toUpperCase() : instance.stringValue(i).toLowerCase();
            values[i] = this.getOutputFormat().attribute(i).addStringValue(newString);
        }
        return new DenseInstance(instance.weight(), values);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: -1 $");
    }

    public static void main(String[] args) {
        ChangeCase.runFilter((Filter)new ChangeCase(), (String[])args);
    }
}

