/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.parsergen;

import java.io.File;
import java.io.IOException;
import java_cup.Main;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ParserGenMojo
extends AbstractMojo {
    protected String[] directories;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.directories.length == 0) {
            throw new MojoExecutionException("At least one directory needs to be specified!");
        }
        for (String directory : this.directories) {
            File dir = new File(directory);
            this.getLog().info((CharSequence)("Processing directory: " + dir));
            try {
                if (!dir.exists()) {
                    throw new IOException("Directory does not exist: " + dir);
                }
                String[] options = new String[]{"--jlex", "--quiet", "--nobak", "--outdir", dir.getAbsolutePath().replace("resources", "java"), dir.getAbsolutePath() + "/Scanner.jflex"};
                JFlex.Main.main((String[])options);
                options = new String[]{"-parser", "Parser", "-interface", "-nosummary", "-destdir", dir.getAbsolutePath().replace("resources", "java"), dir.getAbsolutePath() + "/Parser.cup"};
                Main.main((String[])options);
            }
            catch (Exception e) {
                this.getLog().error((Throwable)e);
                throw new MojoFailureException(e.getMessage());
            }
        }
    }
}

