/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.output;

import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.core.impl.PrefixedStreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.AbstractProcessOutput;
import com.github.fracpete.processoutput4j.reader.AbstractProcessReader;
import com.github.fracpete.processoutput4j.reader.StreamingProcessReader;
import java.util.Arrays;

public class StreamingProcessOutput
extends AbstractProcessOutput {
    private static final long serialVersionUID = 3891848111786764283L;
    protected StreamingProcessOwner m_Owner;

    public StreamingProcessOutput(StreamingProcessOwner owner) {
        this.m_Owner = owner;
    }

    @Override
    protected AbstractProcessReader configureStdErr() {
        return new StreamingProcessReader(this.m_Owner, false);
    }

    @Override
    protected AbstractProcessReader configureStdOut() {
        return new StreamingProcessReader(this.m_Owner, true);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("No command (+ options) provided!");
            System.exit(1);
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(args);
        StreamingProcessOutput out = new StreamingProcessOutput(new PrefixedStreamingProcessOwner());
        out.monitor(builder);
        System.out.println();
        System.out.println("Command:");
        System.out.println(Arrays.asList(args));
        System.out.println("Exit code:");
        System.out.println(out.getExitCode());
    }
}

