/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.reader;

import com.github.fracpete.processoutput4j.reader.AbstractProcessReader;

public class ConsoleOutputProcessReader
extends AbstractProcessReader {
    public static String PREFIX_STDOUT = "[OUT] ";
    public static String PREFIX_STDERR = "[ERR] ";
    protected String m_Prefix;

    public ConsoleOutputProcessReader(boolean stdout) {
        this(stdout, null);
    }

    public ConsoleOutputProcessReader(boolean stdout, String prefix) {
        super(stdout);
        this.m_Prefix = prefix == null ? (stdout ? PREFIX_STDOUT : PREFIX_STDERR) : prefix;
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    protected void process(String line) {
        if (this.m_Stdout) {
            System.out.println(this.m_Prefix + line);
        } else {
            System.err.println(this.m_Prefix + line);
        }
    }
}

