/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.output;

import com.github.fracpete.processoutput4j.core.AbstractProcessRunnable;
import com.github.fracpete.processoutput4j.core.EnvironmentUtils;
import com.github.fracpete.processoutput4j.reader.AbstractProcessReader;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Serializable;

public abstract class AbstractProcessOutput
implements Serializable {
    private static final long serialVersionUID = 1902809285333524039L;
    protected String[] m_Command;
    protected String[] m_Environment;
    protected int m_ExitCode;
    protected transient Process m_Process;
    protected int m_TimeOut;
    protected boolean m_TimedOut;
    protected transient AbstractProcessReader m_ReaderStdErr;
    protected transient AbstractProcessReader m_ReaderStdOut;
    protected transient AbstractProcessRunnable m_RunnableTimeout;

    public AbstractProcessOutput() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Command = new String[0];
        this.m_Environment = null;
        this.m_ExitCode = 0;
        this.m_Process = null;
        this.m_TimeOut = -1;
        this.m_TimedOut = false;
    }

    public void setTimeOut(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_TimeOut = value;
    }

    public int getTimeOut() {
        return this.m_TimeOut;
    }

    public void monitor(ProcessBuilder builder) throws Exception {
        this.monitor(null, builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(String input, ProcessBuilder builder) throws Exception {
        this.m_Command = builder.command().toArray(new String[0]);
        this.m_Environment = EnvironmentUtils.envMapToArray(builder.environment());
        this.m_TimedOut = false;
        this.m_ReaderStdErr = this.configureStdErr();
        Thread threade = new Thread(this.m_ReaderStdErr);
        threade.start();
        this.m_ReaderStdOut = this.configureStdOut();
        Thread threado = new Thread(this.m_ReaderStdOut);
        threado.start();
        this.m_RunnableTimeout = null;
        if (this.m_TimeOut > 0) {
            this.m_RunnableTimeout = this.configureTimeOutMonitor();
            Thread threadt = new Thread(this.m_RunnableTimeout);
            threadt.start();
        }
        this.m_Process = builder.start();
        this.m_ReaderStdErr.setProcess(this.m_Process);
        this.m_ReaderStdOut.setProcess(this.m_Process);
        if (this.m_RunnableTimeout != null) {
            this.m_RunnableTimeout.setProcess(this.m_Process);
        }
        if (input != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_Process.getOutputStream()));
            writer.write(input);
            writer.close();
        }
        this.m_ExitCode = this.m_Process.waitFor();
        while (threade.isAlive() || threado.isAlive()) {
            try {
                AbstractProcessOutput abstractProcessOutput = this;
                synchronized (abstractProcessOutput) {
                    this.wait(100L);
                }
                if (!this.m_TimedOut) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (this.m_TimedOut) {
            if (threade.isAlive()) {
                threade.interrupt();
            }
            if (threado.isAlive()) {
                threado.interrupt();
            }
        }
        this.flush();
        this.m_Process = null;
    }

    public void monitor(String cmd, String[] env, Process process) throws Exception {
        this.monitor(cmd, env, null, process);
    }

    public void monitor(String cmd, String[] env, String input, Process process) throws Exception {
        this.monitor(new String[]{cmd}, env, input, process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitor(String[] cmd, String[] env, String input, Process process) throws Exception {
        this.m_Command = cmd;
        this.m_Environment = env;
        this.m_Process = process;
        this.m_TimedOut = false;
        this.m_ReaderStdErr = this.configureStdErr();
        Thread threade = new Thread(this.m_ReaderStdErr);
        threade.start();
        this.m_ReaderStdErr.setProcess(this.m_Process);
        this.m_ReaderStdOut = this.configureStdOut();
        Thread threado = new Thread(this.m_ReaderStdOut);
        threado.start();
        this.m_ReaderStdOut.setProcess(this.m_Process);
        this.m_RunnableTimeout = null;
        if (this.m_TimeOut > 0) {
            this.m_RunnableTimeout = this.configureTimeOutMonitor();
            Thread threadt = new Thread(this.m_RunnableTimeout);
            threadt.start();
            this.m_RunnableTimeout.setProcess(this.m_Process);
        }
        if (input != null) {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(this.m_Process.getOutputStream()));
            writer.write(input);
            writer.close();
        }
        this.m_ExitCode = this.m_Process.waitFor();
        while (threade.isAlive() || threado.isAlive()) {
            try {
                AbstractProcessOutput abstractProcessOutput = this;
                synchronized (abstractProcessOutput) {
                    this.wait(100L);
                }
                if (!this.m_TimedOut) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (this.m_TimedOut) {
            if (threade.isAlive()) {
                threade.interrupt();
            }
            if (threado.isAlive()) {
                threado.interrupt();
            }
        }
        this.flush();
        this.m_Process = null;
        this.m_ReaderStdErr = null;
        this.m_ReaderStdOut = null;
        this.m_RunnableTimeout = null;
    }

    protected abstract AbstractProcessReader configureStdErr();

    protected abstract AbstractProcessReader configureStdOut();

    protected AbstractProcessRunnable configureTimeOutMonitor() {
        return new AbstractProcessRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() {
                long start = System.currentTimeMillis();
                while (this.m_Process.isAlive()) {
                    try {
                        1 var3_2 = this;
                        synchronized (var3_2) {
                            this.wait(500L);
                        }
                        if (!this.m_Process.isAlive() || (System.currentTimeMillis() - start) / 1000L < (long)AbstractProcessOutput.this.m_TimeOut) continue;
                        AbstractProcessOutput.this.m_TimedOut = true;
                        this.logError("Timeout of " + AbstractProcessOutput.this.m_TimeOut + " seconds reached, terminating process...");
                        this.m_Process.destroy();
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        };
    }

    public String[] getCommand() {
        return this.m_Command;
    }

    public String[] getEnvironment() {
        return this.m_Environment;
    }

    public boolean hasSucceeded() {
        return this.m_ExitCode == 0 && !this.hasTimedOut();
    }

    public int getExitCode() {
        return this.m_ExitCode;
    }

    public boolean hasTimedOut() {
        return this.m_TimedOut;
    }

    public Process getProcess() {
        return this.m_Process;
    }

    public void flush() {
        if (this.m_ReaderStdErr != null) {
            this.m_ReaderStdErr.flush();
        }
        if (this.m_ReaderStdOut != null) {
            this.m_ReaderStdOut.flush();
        }
    }

    public void destroy() {
        if (this.m_Process != null) {
            this.m_Process.destroy();
        }
        if (this.m_ReaderStdErr != null) {
            this.m_ReaderStdErr.stopExecution();
        }
        if (this.m_ReaderStdOut != null) {
            this.m_ReaderStdOut.stopExecution();
        }
        if (this.m_RunnableTimeout != null) {
            this.m_RunnableTimeout.stopExecution();
        }
        this.flush();
    }

    public String toString() {
        return "exit code=" + this.m_ExitCode;
    }
}

