/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.processoutput4j.core;

public class ProcessUtils {
    protected static Boolean m_IsWindows;
    protected static Boolean m_IsLinux;
    protected static Boolean m_IsAndroid;

    public static synchronized boolean isWindows() {
        if (m_IsWindows == null) {
            m_IsWindows = System.getProperty("os.name").toLowerCase().contains("windows");
        }
        return m_IsWindows;
    }

    public static synchronized boolean isAndroid() {
        if (m_IsAndroid == null) {
            m_IsAndroid = System.getProperty("java.vm.vendor").toLowerCase().contains("android") || System.getProperty("java.vendor").toLowerCase().contains("android") || System.getProperty("java.vendor.url").toLowerCase().contains("android");
        }
        return m_IsAndroid;
    }

    public static synchronized boolean isLinux() {
        if (m_IsLinux == null) {
            m_IsLinux = System.getProperty("os.name").toLowerCase().startsWith("linux") && !ProcessUtils.isAndroid();
        }
        return m_IsLinux;
    }

    public static void destroy(Process process) {
        ProcessUtils.destroy(process, false);
    }

    public static void destroy(Process process, boolean force) {
        boolean useFallback = true;
        String[] cmd = null;
        if (ProcessUtils.isLinux()) {
            cmd = force ? new String[]{"kill", "-9", "" + process.pid()} : new String[]{"kill", "" + process.pid()};
        } else if (ProcessUtils.isWindows()) {
            cmd = force ? new String[]{"taskkill", "/T", "/F", "/PID", "" + process.pid()} : new String[]{"taskkill", "/T", "/PID", "" + process.pid()};
        }
        if (cmd != null) {
            try {
                Process kill = new ProcessBuilder(new String[0]).command(cmd).start();
                int exitCode = kill.waitFor();
                useFallback = exitCode != 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (useFallback) {
            process.destroyForcibly();
        }
    }
}

