/*
 * Decompiled with CFR 0.152.
 */
package weka.core.stemmers;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import ptstemmer.exceptions.PTStemmerException;
import ptstemmer.implementations.OrengoStemmer;
import ptstemmer.implementations.PorterStemmer;
import ptstemmer.implementations.SavoyStemmer;
import ptstemmer.support.PTStemmerUtilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.stemmers.Stemmer;
import weka.core.stemmers.Stemming;

public class PTStemmer
implements Stemmer,
OptionHandler {
    static final long serialVersionUID = -6113024782588197L;
    public static final int STEMMER_ORENGO = 0;
    public static final int STEMMER_PORTER = 1;
    public static final int STEMMER_SAVOY = 2;
    public static final Tag[] TAGS_STEMMERS = new Tag[]{new Tag(0, "orengo", "Orengo"), new Tag(1, "porter", "Porter"), new Tag(2, "savoy", "Savoy")};
    protected int m_Stemmer = 0;
    protected File m_NamedEntities = new File(".");
    protected File m_Stopwords = new File(".");
    protected int m_Cache = 1000;
    protected ptstemmer.Stemmer m_ActualStemmer;

    public String globalInfo() {
        return "A wrapper for PTStemmer (developed by Pedro Oliveira):\nhttp://code.google.com/p/ptstemmer/";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        String desc = "";
        for (int i = 0; i < TAGS_STEMMERS.length; ++i) {
            SelectedTag tag = new SelectedTag(TAGS_STEMMERS[i].getID(), TAGS_STEMMERS);
            desc = desc + "\t" + tag.getSelectedTag().getIDStr() + " = " + tag.getSelectedTag().getReadable() + "\n";
        }
        result.addElement(new Option("\tThe type of stemmer algorithm to use:\n" + desc + "\t(default: " + new SelectedTag(0, TAGS_STEMMERS) + ")", "S", 1, "-S " + Tag.toOptionList((Tag[])TAGS_STEMMERS)));
        result.addElement(new Option("\tThe file with the named entities to ignore (optional).\n\tFile format: simple text file with one entity per line.\n\t(default: none)\n", "N", 1, "-N <file>"));
        result.addElement(new Option("\tThe file with the stopwords (optional).\n\tFile format: simple text file with one stopword per line.\n\t(default: none)\n", "W", 1, "-W <file>"));
        result.addElement(new Option("\tThe size of the cache. Disable with 0.\n\t(default: 1000)\n", "C", 1, "-C <int>"));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'S', (String[])options);
        if (tmpStr.length() != 0) {
            this.setStemmer(new SelectedTag(tmpStr, TAGS_STEMMERS));
        } else {
            this.setStemmer(new SelectedTag(0, TAGS_STEMMERS));
        }
        tmpStr = Utils.getOption((char)'N', (String[])options);
        if (tmpStr.length() != 0) {
            this.setNamedEntities(new File(tmpStr));
        } else {
            this.setNamedEntities(new File("."));
        }
        tmpStr = Utils.getOption((char)'W', (String[])options);
        if (tmpStr.length() != 0) {
            this.setStopwords(new File(tmpStr));
        } else {
            this.setStopwords(new File("."));
        }
        tmpStr = Utils.getOption((char)'C', (String[])options);
        if (tmpStr.length() != 0) {
            this.setCache(Integer.parseInt(tmpStr));
        } else {
            this.setCache(1000);
        }
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getStemmer());
        result.add("-N");
        result.add("" + this.getNamedEntities());
        result.add("-W");
        result.add("" + this.getStopwords());
        result.add("-C");
        result.add("" + this.getCache());
        return result.toArray(new String[result.size()]);
    }

    public void setStemmer(SelectedTag value) {
        if (value.getTags() == TAGS_STEMMERS) {
            this.m_Stemmer = value.getSelectedTag().getID();
            this.invalidate();
        }
    }

    public SelectedTag getStemmer() {
        return new SelectedTag(this.m_Stemmer, TAGS_STEMMERS);
    }

    public String stemmerTipText() {
        return "Sets the type of stemmer to use.";
    }

    public void setNamedEntities(File value) {
        this.m_NamedEntities = value;
        this.invalidate();
    }

    public File getNamedEntities() {
        return this.m_NamedEntities;
    }

    public String namedEntitiesTipText() {
        return "The file with the named entities to ignore (format: text file with one entity per line); gets ignored if pointing to a directory.";
    }

    public void setStopwords(File value) {
        this.m_Stopwords = value;
        this.invalidate();
    }

    public File getStopwords() {
        return this.m_Stopwords;
    }

    public String stopwordsTipText() {
        return "The file with the stopwords to ignore (format: text file with one stopword per line); gets ignored if pointing to a directory.";
    }

    public void setCache(int value) {
        this.m_Cache = value;
        this.invalidate();
    }

    public int getCache() {
        return this.m_Cache;
    }

    public String cacheTipText() {
        return "The size of the cache (use 0 to disable caching).";
    }

    protected void invalidate() {
        this.m_ActualStemmer = null;
    }

    protected synchronized ptstemmer.Stemmer getActualStemmer() throws PTStemmerException {
        if (this.m_ActualStemmer == null) {
            if (this.m_Stemmer == 0) {
                this.m_ActualStemmer = new OrengoStemmer();
            } else if (this.m_Stemmer == 1) {
                this.m_ActualStemmer = new PorterStemmer();
            } else if (this.m_Stemmer == 2) {
                this.m_ActualStemmer = new SavoyStemmer();
            } else {
                throw new IllegalStateException("Unhandled stemmer type: " + this.m_Stemmer);
            }
            if (!this.m_NamedEntities.isDirectory()) {
                this.m_ActualStemmer.ignore((Collection)PTStemmerUtilities.fileToSet((String)this.m_NamedEntities.getAbsolutePath()));
            }
            if (!this.m_Stopwords.isDirectory()) {
                this.m_ActualStemmer.ignore((Collection)PTStemmerUtilities.fileToSet((String)this.m_Stopwords.getAbsolutePath()));
            }
            if (this.m_Cache > 0) {
                this.m_ActualStemmer.enableCaching(this.m_Cache);
            } else {
                this.m_ActualStemmer.disableCaching();
            }
        }
        return this.m_ActualStemmer;
    }

    public String stem(String word) {
        String ret = null;
        try {
            ret = this.getActualStemmer().getWordStem(word);
        }
        catch (PTStemmerException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 1179 $");
    }

    public static void main(String[] args) {
        try {
            Stemming.useStemmer((Stemmer)new PTStemmer(), (String[])args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

