/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer;

import java.util.Collection;
import java.util.HashSet;
import ptstemmer.exceptions.PTStemmerException;
import ptstemmer.implementations.OrengoStemmer;
import ptstemmer.implementations.PorterStemmer;
import ptstemmer.implementations.SavoyStemmer;
import ptstemmer.support.datastructures.LRUCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Stemmer {
    private boolean cacheStems;
    private LRUCache lruCache;
    private HashSet<String> toIgnore = new HashSet();

    public static Stemmer StemmerFactory(StemmerType stype) throws PTStemmerException {
        switch (stype) {
            case PORTER: {
                return new PorterStemmer();
            }
            case SAVOY: {
                return new SavoyStemmer();
            }
        }
        return new OrengoStemmer();
    }

    public void enableCaching(int size) {
        this.cacheStems = true;
        this.lruCache = new LRUCache(size);
    }

    public void disableCaching() {
        this.cacheStems = false;
        this.lruCache = null;
    }

    public boolean isCachingEnabled() {
        return this.cacheStems;
    }

    public void ignore(String ... words) {
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            this.toIgnore.add(word);
            ++n2;
        }
    }

    public void ignore(Collection<String> words) {
        this.toIgnore.addAll(words);
    }

    public void clearIgnoreList() {
        this.toIgnore.clear();
    }

    public String[] getPhraseStems(String phrase) {
        String[] res = phrase.split(" ");
        int i = 0;
        while (i < res.length) {
            res[i] = this.getWordStem(res[i]);
            ++i;
        }
        return res;
    }

    public String getWordStem(String word) {
        word = word.trim().toLowerCase();
        if (this.cacheStems && this.lruCache.containsKey(word)) {
            return (String)this.lruCache.get(word);
        }
        if (this.toIgnore.contains(word)) {
            return word;
        }
        String res = this.stemming(word);
        if (this.cacheStems) {
            this.lruCache.put(word, res);
        }
        return res;
    }

    protected abstract String stemming(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StemmerType {
        ORENGO,
        PORTER,
        SAVOY;

    }
}

