/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer.implementations;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ptstemmer.Stemmer;
import ptstemmer.exceptions.PTStemmerException;
import ptstemmer.implementations.SavoyStemmer;
import ptstemmer.support.XMLUtils;
import ptstemmer.support.datastructures.Pair;
import ptstemmer.support.datastructures.SuffixTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrengoStemmer
extends Stemmer {
    private SuffixTree<Rule> pluralreductionrules;
    private SuffixTree<Rule> femininereductionrules;
    private SuffixTree<Rule> adverbreductionrules;
    private SuffixTree<Rule> augmentativediminutivereductionrules;
    private SuffixTree<Rule> nounreductionrules;
    private SuffixTree<Rule> verbreductionrules;
    private SuffixTree<Rule> vowelremovalrules;

    public OrengoStemmer() throws PTStemmerException {
        this.readRulesFromXML();
    }

    @Override
    protected String stemming(String word) {
        return this.algorithm(word);
    }

    private String algorithm(String st) {
        String stem = st;
        if (st.length() < 1) {
            return st;
        }
        char end = stem.charAt(stem.length() - 1);
        if (end == 's') {
            stem = this.applyRules(stem, this.pluralreductionrules);
        }
        if ((end = stem.charAt(stem.length() - 1)) == 'a' || end == '\u00e3') {
            stem = this.applyRules(stem, this.femininereductionrules);
        }
        stem = this.applyRules(stem, this.augmentativediminutivereductionrules);
        String aux = stem = this.applyRules(stem, this.adverbreductionrules);
        if (aux.equals(stem = this.applyRules(stem, this.nounreductionrules)) && aux.equals(stem = this.applyRules(stem, this.verbreductionrules))) {
            stem = this.applyRules(stem, this.vowelremovalrules);
        }
        return stem;
    }

    private String applyRules(String st, SuffixTree<Rule> rules) {
        if (st.length() < rules.getProperty("size")) {
            return st;
        }
        List<Pair<String, Rule>> res = rules.getLongestSuffixesAndValues(st);
        int i = res.size() - 1;
        while (i >= 0) {
            Pair<String, Rule> r = res.get(i);
            String suffix = (String)r.a;
            Rule rule = (Rule)r.b;
            if (rules.getProperty("exceptions") != 1 ? rule.exceptions.getLongestSuffixValue(st) != null : rule.exceptions.contains(st)) break;
            if (st.length() >= suffix.length() + rule.size) {
                return String.valueOf(st.substring(0, st.length() - suffix.length())) + rule.replacement;
            }
            --i;
        }
        return st;
    }

    private void readRulesFromXML() throws PTStemmerException {
        Document document;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(SavoyStemmer.class.getResourceAsStream("OrengoStemmerRules.xml"));
        }
        catch (Exception e) {
            throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file.", e);
        }
        Element root = document.getDocumentElement();
        for (Element step : XMLUtils.getChilds(root)) {
            if (!step.hasAttribute("name")) {
                throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file: Invalid step.");
            }
            String stepName = step.getAttribute("name");
            SuffixTree<Rule> suffixes = new SuffixTree<Rule>();
            XMLUtils.setProperty(suffixes, "size", 0, step);
            XMLUtils.setProperty(suffixes, "exceptions", 0, step);
            for (Element rule : XMLUtils.getChilds(step)) {
                Rule r;
                if (!(rule.hasAttribute("size") && rule.hasAttribute("replacement") && rule.hasAttribute("suffix"))) {
                    throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file: Invalid rule in " + stepName + ".");
                }
                String suffix = rule.getAttribute("suffix");
                ArrayList<String> exceptions = new ArrayList<String>();
                for (Element exception : XMLUtils.getChilds(rule)) {
                    if (!exception.getTagName().equals("exception") || !exception.hasChildNodes()) {
                        throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file: Invalid exception in step " + stepName + ", rule " + suffix + ".");
                    }
                    exceptions.add(exception.getChildNodes().item(0).getNodeValue());
                }
                try {
                    r = new Rule(Integer.parseInt(rule.getAttribute("size")), rule.getAttribute("replacement"), exceptions.toArray(new String[exceptions.size()]));
                }
                catch (NumberFormatException e) {
                    throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file: Missing or invalid rules properties on step " + stepName + ".", e);
                }
                suffixes.addSuffix(suffix, r);
            }
            if (stepName.equals("pluralreduction")) {
                this.pluralreductionrules = suffixes;
                continue;
            }
            if (stepName.equals("femininereduction")) {
                this.femininereductionrules = suffixes;
                continue;
            }
            if (stepName.equals("adverbreduction")) {
                this.adverbreductionrules = suffixes;
                continue;
            }
            if (stepName.equals("augmentativediminutivereduction")) {
                this.augmentativediminutivereductionrules = suffixes;
                continue;
            }
            if (stepName.equals("nounreduction")) {
                this.nounreductionrules = suffixes;
                continue;
            }
            if (stepName.equals("verbreduction")) {
                this.verbreductionrules = suffixes;
                continue;
            }
            if (!stepName.equals("vowelremoval")) continue;
            this.vowelremovalrules = suffixes;
        }
        if (this.pluralreductionrules == null || this.femininereductionrules == null || this.adverbreductionrules == null || this.augmentativediminutivereductionrules == null || this.nounreductionrules == null || this.verbreductionrules == null || this.vowelremovalrules == null) {
            throw new PTStemmerException("Problem while parsing Orengo's XML stemming rules file: Missing steps.");
        }
    }

    private class Rule {
        public int size;
        public String replacement;
        public SuffixTree<Boolean> exceptions;

        public Rule(int size, String replacement, String[] exceptions) {
            this.size = size;
            this.replacement = replacement != null ? replacement : "";
            this.exceptions = exceptions == null ? new SuffixTree() : new SuffixTree<Boolean>(true, exceptions);
        }
    }
}

