/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer.implementations;

import java.util.Arrays;
import java.util.HashSet;
import ptstemmer.Stemmer;
import ptstemmer.support.datastructures.SuffixTree;

public class PorterStemmer
extends Stemmer {
    private String suffix;
    private static final HashSet<Character> vowels = new HashSet<Character>(Arrays.asList(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'), Character.valueOf('\u00e1'), Character.valueOf('\u00e9'), Character.valueOf('\u00ed'), Character.valueOf('\u00f3'), Character.valueOf('\u00fa'), Character.valueOf('\u00e2'), Character.valueOf('\u00ea'), Character.valueOf('\u00f4')));
    private static final SuffixTree<Boolean> suffix1 = new SuffixTree<Boolean>(true, "amentos", "imentos", "amento", "imento", "adoras", "adores", "a\u00e7o~es", "ismos", "istas", "adora", "a\u00e7a~o", "antes", "\u00e2ncia", "ezas", "icos", "icas", "ismo", "\u00e1vel", "\u00edvel", "ista", "osos", "osas", "ador", "ante", "eza", "ico", "ica", "oso", "osa");
    private static final SuffixTree<Boolean> suffix2 = new SuffixTree<Boolean>(true, "log\u00edas", "log\u00eda");
    private static final SuffixTree<Boolean> suffix3 = new SuffixTree<Boolean>(true, "uciones", "uci\u00f3n");
    private static final SuffixTree<Boolean> suffix4 = new SuffixTree<Boolean>(true, "\u00eancias", "\u00eancia");
    private static final SuffixTree<Boolean> suffix5 = new SuffixTree<Boolean>(true, "amente");
    private static final SuffixTree<Boolean> suffix6 = new SuffixTree<Boolean>(true, "mente");
    private static final SuffixTree<Boolean> suffix7 = new SuffixTree<Boolean>(true, "idades", "idade");
    private static final SuffixTree<Boolean> suffix8 = new SuffixTree<Boolean>(true, "ivas", "ivos", "iva", "ivo");
    private static final SuffixTree<Boolean> suffix9 = new SuffixTree<Boolean>(true, "iras", "ira");
    private static final SuffixTree<Boolean> suffixv = new SuffixTree<Boolean>(true, "ar\u00edamos", "er\u00edamos", "ir\u00edamos", "\u00e1ssemos", "\u00eassemos", "\u00edssemos", "ar\u00edeis", "er\u00edeis", "ir\u00edeis", "\u00e1sseis", "\u00e9sseis", "\u00edsseis", "\u00e1ramos", "\u00e9ramos", "\u00edramos", "\u00e1vamos", "aremos", "eremos", "iremos", "ariam", "eriam", "iriam", "assem", "essem", "issem", "ara~o", "era~o", "ira~o", "arias", "erias", "irias", "ardes", "erdes", "irdes", "asses", "esses", "isses", "astes", "estes", "istes", "\u00e1reis", "areis", "\u00e9reis", "ereis", "\u00edreis", "ireis", "\u00e1veis", "\u00edamos", "armos", "ermos", "irmos", "aria", "eria", "iria", "asse", "esse", "isse", "aste", "este", "iste", "arei", "erei", "irei", "aram", "eram", "iram", "avam", "arem", "erem", "irem", "ando", "endo", "indo", "adas", "idas", "ar\u00e1s", "aras", "er\u00e1s", "eras", "ir\u00e1s", "avas", "ares", "eres", "ires", "\u00edeis", "ados", "idos", "\u00e1mos", "amos", "emos", "imos", "iras", "ada", "ida", "ar\u00e1", "ara", "er\u00e1", "era", "ir\u00e1", "ava", "iam", "ado", "ido", "ias", "ais", "eis", "ira", "ia", "ei", "am", "em", "ar", "er", "ir", "as", "es", "is", "eu", "iu", "ou");
    private static final SuffixTree<Boolean> suffixr = new SuffixTree<Boolean>(true, "os", "a", "i", "o", "\u00e1", "\u00ed", "\u00f3");
    private static final SuffixTree<Boolean> suffixf = new SuffixTree<Boolean>(true, "e", "\u00e9", "\u00ea");

    public String stemming(String word) {
        return this.algorithm(word);
    }

    private String algorithm(String st) {
        String rv;
        String r2;
        String stem = st = this.processNasalidedVowels(st);
        String r1 = this.findR(stem);
        if ((stem = this.step1(stem, r1, r2 = this.findR(r1), rv = this.findRV(stem))).compareTo(st) == 0) {
            stem = this.step2(stem, r1, r2, rv);
        } else {
            r1 = this.findR(stem);
            r2 = this.findR(r1);
            rv = this.findRV(stem);
        }
        if (stem.compareTo(st) != 0) {
            r1 = this.findR(stem);
            r2 = this.findR(r1);
            rv = this.findRV(stem);
            stem = this.step3(stem, r1, r2, rv);
        } else {
            stem = this.step4(stem, r1, r2, rv);
        }
        if (stem.compareTo(st) != 0) {
            r1 = this.findR(stem);
            r2 = this.findR(r1);
            rv = this.findRV(stem);
        }
        stem = this.step5(stem, r1, r2, rv);
        stem = this.deprocessNasalidedVowels(stem);
        return stem;
    }

    private String step1(String st, String r1, String r2, String rv) {
        this.suffix = suffix1.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            return st.substring(0, st.length() - this.suffix.length());
        }
        this.suffix = suffix2.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            return String.valueOf(st.substring(0, st.length() - this.suffix.length())) + "log";
        }
        this.suffix = suffix3.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            return String.valueOf(st.substring(0, st.length() - this.suffix.length())) + "u";
        }
        this.suffix = suffix4.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            return String.valueOf(st.substring(0, st.length() - this.suffix.length())) + "ente";
        }
        this.suffix = suffix5.getLongestSuffix(r1);
        if (!this.suffix.isEmpty()) {
            if ((st = st.substring(0, st.length() - this.suffix.length())).endsWith("iv") && r2.endsWith("iv" + this.suffix)) {
                if ((st = st.substring(0, st.length() - 2)).endsWith("at") && r2.endsWith("ativ" + this.suffix)) {
                    st = st.substring(0, st.length() - 2);
                }
            } else if (st.endsWith("os") && r2.endsWith("os" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            } else if (st.endsWith("ic") && r2.endsWith("ic" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            } else if (st.endsWith("ad") && r2.endsWith("ad" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            }
            return st;
        }
        this.suffix = suffix6.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            if ((st = st.substring(0, st.length() - this.suffix.length())).endsWith("ante") && r2.endsWith("ante" + this.suffix)) {
                st = st.substring(0, st.length() - 4);
            } else if (st.endsWith("avel") && r2.endsWith("avel" + this.suffix)) {
                st = st.substring(0, st.length() - 4);
            } else if (st.endsWith("\u00edvel") && r2.endsWith("\u00edvel" + this.suffix)) {
                st = st.substring(0, st.length() - 4);
            }
            return st;
        }
        this.suffix = suffix7.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            if ((st = st.substring(0, st.length() - this.suffix.length())).endsWith("abil") && r2.endsWith("abil" + this.suffix)) {
                st = st.substring(0, st.length() - 4);
            } else if (st.endsWith("ic") && r2.endsWith("ic" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            } else if (st.endsWith("iv") && r2.endsWith("iv" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            }
            return st;
        }
        this.suffix = suffix8.getLongestSuffix(r2);
        if (!this.suffix.isEmpty()) {
            if ((st = st.substring(0, st.length() - this.suffix.length())).endsWith("at") && r2.endsWith("at" + this.suffix)) {
                st = st.substring(0, st.length() - 2);
            }
            return st;
        }
        this.suffix = suffix9.getLongestSuffix(rv);
        if (!this.suffix.isEmpty()) {
            if (st.endsWith("e" + this.suffix)) {
                st = String.valueOf(st.substring(0, st.length() - this.suffix.length())) + "ir";
            }
            return st;
        }
        return st;
    }

    private String step2(String st, String r1, String r2, String rv) {
        this.suffix = suffixv.getLongestSuffix(rv);
        if (!this.suffix.isEmpty()) {
            return st.substring(0, st.length() - this.suffix.length());
        }
        return st;
    }

    private String step3(String st, String r1, String r2, String rv) {
        if (rv.endsWith("i") && st.endsWith("ci")) {
            return st.substring(0, st.length() - 1);
        }
        return st;
    }

    private String step4(String st, String r1, String r2, String rv) {
        this.suffix = suffixr.getLongestSuffix(rv);
        if (!this.suffix.isEmpty()) {
            return st.substring(0, st.length() - this.suffix.length());
        }
        return st;
    }

    private String step5(String st, String r1, String r2, String rv) {
        this.suffix = suffixf.getLongestSuffix(rv);
        if (!this.suffix.isEmpty()) {
            if ((st = st.substring(0, st.length() - this.suffix.length())).endsWith("gu") && rv.endsWith("u" + this.suffix)) {
                st = st.substring(0, st.length() - 1);
            } else if (st.endsWith("ci") && rv.endsWith("i" + this.suffix)) {
                st = st.substring(0, st.length() - 1);
            }
            return st;
        }
        if (st.endsWith("\u00e7")) {
            st = String.valueOf(st.substring(0, st.length() - 1)) + "c";
        }
        return st;
    }

    private String findR(String st) {
        int i = 0;
        while (i < st.length() - 1) {
            if (vowels.contains(Character.valueOf(st.charAt(i))) && !vowels.contains(Character.valueOf(st.charAt(i + 1)))) {
                return st.substring(i + 2);
            }
            ++i;
        }
        return "";
    }

    private String findRV(String st) {
        if (st.length() > 2) {
            if (!vowels.contains(Character.valueOf(st.charAt(1)))) {
                int i = 2;
                while (i < st.length() - 1) {
                    if (vowels.contains(Character.valueOf(st.charAt(i)))) {
                        return st.substring(i + 1);
                    }
                    ++i;
                }
            } else if (vowels.contains(Character.valueOf(st.charAt(0))) && vowels.contains(Character.valueOf(st.charAt(1)))) {
                int i = 2;
                while (i < st.length() - 1) {
                    if (!vowels.contains(Character.valueOf(st.charAt(i)))) {
                        return st.substring(i + 1);
                    }
                    ++i;
                }
            } else {
                return st.substring(2);
            }
        }
        return "";
    }

    private String processNasalidedVowels(String st) {
        st = st.replaceAll("\u00e3", "a~");
        st = st.replaceAll("\u00f5", "o~");
        return st;
    }

    private String deprocessNasalidedVowels(String st) {
        st = st.replaceAll("a~", "\u00e3");
        st = st.replaceAll("o~", "\u00f5");
        return st;
    }
}

