/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer.implementations;

import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ptstemmer.Stemmer;
import ptstemmer.exceptions.PTStemmerException;
import ptstemmer.support.XMLUtils;
import ptstemmer.support.datastructures.Pair;
import ptstemmer.support.datastructures.SuffixTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SavoyStemmer
extends Stemmer {
    private SuffixTree<Rule> pluralreductionrules;
    private SuffixTree<Rule> femininereductionrules;
    private SuffixTree<Rule> finalvowel;

    public SavoyStemmer() throws PTStemmerException {
        this.parseXML();
    }

    @Override
    protected String stemming(String word) {
        return this.algorithm(word);
    }

    private String algorithm(String word) {
        int length = word.length() - 1;
        if (length > 2) {
            length = (word = this.applyRules(word, this.pluralreductionrules)).length() - 1;
            if (length > 5 && word.charAt(length) == 'a') {
                word = this.applyRules(word, this.femininereductionrules);
            }
            length = word.length() - 1;
            char lastChar = word.charAt(length);
            if (length > 3 && (lastChar == 'a' || lastChar == 'e' || lastChar == 'o')) {
                word = word.substring(0, length);
            }
        }
        return word;
    }

    private String applyRules(String st, SuffixTree<Rule> rules) {
        int length = st.length() - 1;
        if (length < rules.getProperty("size")) {
            return st;
        }
        List<Pair<String, Rule>> res = rules.getLongestSuffixesAndValues(st);
        int i = res.size() - 1;
        while (i >= 0) {
            Pair<String, Rule> r = res.get(i);
            String suffix = (String)r.a;
            Rule rule = (Rule)r.b;
            if (length > rule.size) {
                return String.valueOf(st.substring(0, st.length() - suffix.length())) + rule.replacement;
            }
            --i;
        }
        return st;
    }

    private void parseXML() throws PTStemmerException {
        Document document;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(SavoyStemmer.class.getResourceAsStream("SavoyStemmerRules.xml"));
        }
        catch (Exception e) {
            throw new PTStemmerException("Problem while parsing Savoy's XML stemming rules file.", e);
        }
        Element root = document.getDocumentElement();
        for (Element step : XMLUtils.getChilds(root)) {
            if (!step.hasAttribute("name")) {
                throw new PTStemmerException("Problem while parsing Savoy's XML stemming rules file: Invalid step.");
            }
            String stepName = step.getAttribute("name");
            SuffixTree<Rule> suffixes = new SuffixTree<Rule>();
            XMLUtils.setProperty(suffixes, "size", 0, step);
            for (Element rule : XMLUtils.getChilds(step)) {
                Rule r;
                if (!(rule.hasAttribute("size") && rule.hasAttribute("replacement") && rule.hasAttribute("suffix"))) {
                    throw new PTStemmerException("Problem while parsing Savoy's XML stemming rules file: Invalid rule in " + stepName + ".");
                }
                String suffix = rule.getAttribute("suffix");
                try {
                    r = new Rule(Integer.parseInt(rule.getAttribute("size")), rule.getAttribute("replacement"));
                }
                catch (NumberFormatException e) {
                    throw new PTStemmerException("Problem while parsing Savoy's XML stemming rules file: Missing or invalid rules properties on step " + stepName + ".", e);
                }
                suffixes.addSuffix(suffix, r);
            }
            if (stepName.equals("pluralreduction")) {
                this.pluralreductionrules = suffixes;
                continue;
            }
            if (stepName.equals("femininereduction")) {
                this.femininereductionrules = suffixes;
                continue;
            }
            if (!stepName.equals("finalvowel")) continue;
            this.finalvowel = suffixes;
        }
        if (this.pluralreductionrules == null || this.femininereductionrules == null || this.finalvowel == null) {
            throw new PTStemmerException("Problem while parsing Savoy's XML stemming rules file: Missing steps.");
        }
    }

    private class Rule {
        public int size;
        public String replacement;

        public Rule(int size, String replacement) {
            this.size = size;
            this.replacement = replacement;
        }
    }
}

