/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer.support;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.Set;
import ptstemmer.exceptions.PTStemmerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PTStemmerUtilities {
    public static Set<String> fileToSet(String filename) throws PTStemmerException {
        HashSet<String> res = new HashSet<String>();
        try {
            String aux;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            while ((aux = in.readLine()) != null) {
                res.add(aux.trim().toLowerCase());
            }
        }
        catch (IOException e) {
            throw new PTStemmerException("Problems opening file " + filename, e);
        }
        return res;
    }

    public static String removeDiacritics(String st) {
        st = Normalizer.normalize(st, Normalizer.Form.NFD);
        return st.replaceAll("[^\\p{ASCII}]", "");
    }
}

