/*
 * Decompiled with CFR 0.152.
 */
package ptstemmer.support.datastructures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import ptstemmer.support.datastructures.Pair;
import ptstemmer.support.datastructures.SuffixTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuffixTree<T> {
    private SuffixTreeNode<T> root = new SuffixTreeNode();
    private HashMap<String, Integer> properties = new HashMap(2);

    public SuffixTree() {
    }

    public SuffixTree(T value, String ... suffixes) {
        this();
        String[] stringArray = suffixes;
        int n = suffixes.length;
        int n2 = 0;
        while (n2 < n) {
            String suffix = stringArray[n2];
            this.addSuffix(suffix, value);
            ++n2;
        }
    }

    public void setProperty(String property, Integer value) {
        this.properties.put(property, value);
    }

    public Integer getProperty(String property) {
        return this.properties.get(property);
    }

    public boolean containsProperty(String property) {
        return this.properties.containsKey(property);
    }

    public void addSuffix(String suffix, T value) {
        SuffixTreeNode<Object> node = this.root;
        int i = suffix.length() - 1;
        while (i >= 0) {
            char c = suffix.charAt(i);
            node = node.addEdge(c, null);
            --i;
        }
        node.setValue(value);
    }

    public boolean contains(String word) {
        SuffixTreeNode<T> cnode = this.root;
        int i = word.length() - 1;
        while (i >= 0) {
            char c = word.charAt(i);
            if ((cnode = cnode.getEdge(c)) == null) {
                return false;
            }
            --i;
        }
        return cnode != null && cnode.getValue() != null;
    }

    public T getLongestSuffixValue(String word) {
        Pair<String, T> res = this.getLongestSuffixAndValue(word);
        return res != null ? (T)res.b : null;
    }

    public String getLongestSuffix(String word) {
        Pair<String, T> res = this.getLongestSuffixAndValue(word);
        return res != null ? (String)res.a : "";
    }

    public Pair<String, T> getLongestSuffixAndValue(String word) {
        SuffixTreeNode<T> cnode = this.root;
        int longestSuffixIndex = -1;
        Object valueToReturn = null;
        int i = word.length() - 1;
        while (i >= 0) {
            char c = word.charAt(i);
            if ((cnode = cnode.getEdge(c)) == null) break;
            if (cnode.getValue() != null) {
                longestSuffixIndex = i;
                valueToReturn = cnode.getValue();
            }
            --i;
        }
        if (longestSuffixIndex != -1) {
            return new Pair<String, Object>(word.substring(longestSuffixIndex), valueToReturn);
        }
        return null;
    }

    public List<Pair<String, T>> getLongestSuffixesAndValues(String word) {
        SuffixTreeNode<T> cnode = this.root;
        ArrayList<Pair<String, T>> res = new ArrayList<Pair<String, T>>();
        int i = word.length() - 1;
        while (i >= 0) {
            char c = word.charAt(i);
            if ((cnode = cnode.getEdge(c)) == null) break;
            if (cnode.getValue() != null) {
                res.add(new Pair<String, T>(word.substring(i), cnode.getValue()));
            }
            --i;
        }
        return res;
    }
}

