/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import com.github.fracpete.requests4j.core.AbstractResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FileResponse
extends AbstractResponse {
    protected File m_OutputFile;
    protected int m_BufferSize;
    protected transient FileOutputStream m_FileOutputStream;
    protected transient BufferedOutputStream m_BufferedOutputStream;

    public FileResponse(String outputFilename) {
        this(new File(outputFilename));
    }

    public FileResponse(String outputFilename, int bufferSize) {
        this(new File(outputFilename), bufferSize);
    }

    public FileResponse(File outputFile) {
        this(outputFile, -1);
    }

    public FileResponse(File outputFile, int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = -1;
        }
        this.m_OutputFile = outputFile;
        this.m_BufferSize = bufferSize;
    }

    @Override
    public void init(int statusCode, String statusMessage, Map<String, List<String>> headers) {
        super.init(statusCode, statusMessage, headers);
        this.m_FileOutputStream = null;
    }

    public File outputFile() {
        return this.m_OutputFile;
    }

    public int bufferSize() {
        return this.m_BufferSize;
    }

    @Override
    public void appendBody(byte b) throws IOException {
        if (this.m_FileOutputStream == null) {
            this.m_FileOutputStream = new FileOutputStream(this.m_OutputFile.getAbsolutePath());
            this.m_BufferedOutputStream = this.m_BufferSize <= 0 ? new BufferedOutputStream(this.m_FileOutputStream) : new BufferedOutputStream(this.m_FileOutputStream, this.m_BufferSize);
        }
        this.m_BufferedOutputStream.write(b);
    }

    @Override
    public void finishBody() throws IOException {
        if (this.m_BufferedOutputStream != null) {
            this.m_BufferedOutputStream.flush();
            this.m_BufferedOutputStream.close();
            this.m_BufferedOutputStream = null;
        }
        if (this.m_FileOutputStream != null) {
            this.m_FileOutputStream.flush();
            this.m_FileOutputStream.close();
            this.m_FileOutputStream = null;
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", outputFile=" + this.outputFile() + ", bufferSize=" + (this.bufferSize() <= 0 ? "-default-" : "" + this.bufferSize());
    }
}

